/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.ejb;

import java.util.EnumSet;
import java.util.List;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.model.test.FailedOperationTransformationConfig;
import org.jboss.as.model.test.ModelTestControllerVersion;
import org.jboss.as.model.test.ModelTestKernelServices;
import org.jboss.as.model.test.ModelTestUtils;
import org.jboss.as.subsystem.test.AbstractSubsystemTest;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.as.subsystem.test.KernelServicesBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.extension.clustering.ejb.DistributableEjbExtension;
import org.wildfly.extension.clustering.ejb.DistributableEjbSubsystemModel;

@RunWith(value=Parameterized.class)
public class DistributableEjbTransformersTestCase
extends AbstractSubsystemTest {
    private final ModelTestControllerVersion controller;
    private final ModelVersion version;

    @Parameterized.Parameters
    public static Iterable<ModelTestControllerVersion> parameters() {
        return EnumSet.of(ModelTestControllerVersion.EAP_8_0_0);
    }

    public DistributableEjbTransformersTestCase(ModelTestControllerVersion controller) {
        super("distributable-ejb", (Extension)new DistributableEjbExtension());
        this.controller = controller;
        this.version = this.getModelVersion().getVersion();
    }

    private String formatArtifact(String pattern) {
        return String.format(pattern, this.controller.getMavenGavVersion());
    }

    private String formatSubsystemArtifact() {
        return this.formatArtifact("org.jboss.eap:wildfly-clustering-ejb-extension:%s");
    }

    private DistributableEjbSubsystemModel getModelVersion() {
        switch (this.controller) {
            case EAP_8_0_0: {
                return DistributableEjbSubsystemModel.VERSION_1_0_0;
            }
        }
        throw new IllegalArgumentException();
    }

    private String[] getDependencies() {
        switch (this.controller) {
            case EAP_8_0_0: {
                return new String[]{this.formatSubsystemArtifact(), this.formatArtifact("org.jboss.eap:wildfly-clustering-common:%s"), this.formatArtifact("org.jboss.eap:wildfly-clustering-ee-infinispan:%s"), this.formatArtifact("org.jboss.eap:wildfly-clustering-ejb-infinispan:%s"), this.formatArtifact("org.jboss.eap:wildfly-clustering-ejb-spi:%s"), this.formatArtifact("org.jboss.eap:wildfly-clustering-infinispan-embedded-service:%s"), this.formatArtifact("org.jboss.eap:wildfly-clustering-marshalling-spi:%s"), this.formatArtifact("org.jboss.eap:wildfly-clustering-service:%s")};
            }
        }
        throw new IllegalArgumentException();
    }

    protected AdditionalInitialization createAdditionalInitialization() {
        return new org.jboss.as.clustering.subsystem.AdditionalInitialization().require(InfinispanServiceDescriptor.DEFAULT_CACHE, "foo").require(InfinispanServiceDescriptor.DEFAULT_CACHE_CONFIGURATION, "foo").require(InfinispanServiceDescriptor.CACHE_CONFIGURATION, "foo", "bar");
    }

    @Test
    public void testTransformation() throws Exception {
        String subsystemXmlResource = String.format("distributable-ejb-transform-%s.xml", this.version);
        KernelServices services = this.buildKernelServices(subsystemXmlResource, this.controller, this.version, this.getDependencies());
        this.checkSubsystemModelTransformation(services, this.version, null, false);
    }

    @Test
    public void testRejections() throws Exception {
        KernelServicesBuilder builder = this.createKernelServicesBuilder();
        builder.createLegacyKernelServicesBuilder(this.createAdditionalInitialization(), this.controller, this.version).addSingleChildFirstClass(new Class[]{org.jboss.as.clustering.subsystem.AdditionalInitialization.class}).addMavenResourceURL(this.getDependencies());
        KernelServices services = builder.build();
        KernelServices legacyServices = (KernelServices)services.getLegacyServices(this.version);
        Assert.assertNotNull((Object)legacyServices);
        Assert.assertTrue((boolean)services.isSuccessfulBoot());
        Assert.assertTrue((boolean)legacyServices.isSuccessfulBoot());
        List xmlOps = builder.parseXmlResource("distributable-ejb-reject.xml");
        ModelTestUtils.checkFailedTransformedBootOperations((ModelTestKernelServices)services, (ModelVersion)this.version, (List)xmlOps, (FailedOperationTransformationConfig)DistributableEjbTransformersTestCase.createFailedOperationConfig(this.version));
    }

    private static FailedOperationTransformationConfig createFailedOperationConfig(ModelVersion version) {
        return new FailedOperationTransformationConfig();
    }

    private KernelServicesBuilder createKernelServicesBuilder() {
        return this.createKernelServicesBuilder(this.createAdditionalInitialization());
    }

    private KernelServices buildKernelServices(String subsystemXml, ModelTestControllerVersion controllerVersion, ModelVersion version, String ... mavenResourceURLs) throws Exception {
        KernelServicesBuilder builder = this.createKernelServicesBuilder().setSubsystemXmlResource(subsystemXml);
        builder.createLegacyKernelServicesBuilder(this.createAdditionalInitialization(), controllerVersion, version).addSingleChildFirstClass(new Class[]{org.jboss.as.clustering.subsystem.AdditionalInitialization.class}).addMavenResourceURL(mavenResourceURLs).skipReverseControllerCheck();
        KernelServices services = builder.build();
        Assert.assertTrue((String)(String.valueOf(ModelTestControllerVersion.MASTER) + " boot failed"), (boolean)services.isSuccessfulBoot());
        Assert.assertTrue((String)(controllerVersion.getMavenGavVersion() + " boot failed"), (boolean)((KernelServices)services.getLegacyServices(version)).isSuccessfulBoot());
        return services;
    }
}

