/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.ejb;

import java.io.InputStream;
import java.util.EnumSet;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemSchema;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.subsystem.test.AbstractSubsystemSchemaTest;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.extension.clustering.ejb.BeanManagementResourceDefinitionRegistrar;
import org.wildfly.extension.clustering.ejb.BeanManagementResourceRegistration;
import org.wildfly.extension.clustering.ejb.ClientMappingsRegistryProviderResourceRegistration;
import org.wildfly.extension.clustering.ejb.DistributableEjbExtension;
import org.wildfly.extension.clustering.ejb.DistributableEjbSubsystemResourceDefinitionRegistrar;
import org.wildfly.extension.clustering.ejb.DistributableEjbSubsystemSchema;
import org.wildfly.extension.clustering.ejb.InfinispanBeanManagementResourceDefinitionRegistrar;
import org.wildfly.extension.clustering.ejb.InfinispanClientMappingsRegistryProviderResourceDefinitionRegistrar;
import org.wildfly.extension.clustering.ejb.InfinispanTimerManagementResourceDefinitionRegistrar;

@RunWith(value=Parameterized.class)
public class DistributableEjbSubsystemTestCase
extends AbstractSubsystemSchemaTest<DistributableEjbSubsystemSchema> {
    @Parameterized.Parameters
    public static Iterable<DistributableEjbSubsystemSchema> parameters() {
        return EnumSet.allOf(DistributableEjbSubsystemSchema.class);
    }

    public DistributableEjbSubsystemTestCase(DistributableEjbSubsystemSchema schema) {
        super(DistributableEjbSubsystemResourceDefinitionRegistrar.REGISTRATION.getName(), (Extension)new DistributableEjbExtension(), (SubsystemSchema)schema, (SubsystemSchema)DistributableEjbSubsystemSchema.CURRENT);
    }

    protected AdditionalInitialization createAdditionalInitialization() {
        return new org.jboss.as.clustering.subsystem.AdditionalInitialization().require(InfinispanServiceDescriptor.DEFAULT_CACHE_CONFIGURATION, "foo").require(InfinispanServiceDescriptor.CACHE_CONFIGURATION, "foo", "bar");
    }

    @Test
    public void testInfinispanBeanManagement() throws Exception {
        String subsystemXml = this.getSubsystemXml();
        KernelServices ks = this.createKernelServicesBuilder(this.createAdditionalInitialization()).setSubsystemXml(subsystemXml).build();
        Assert.assertTrue((String)"Subsystem boot failed!", (boolean)ks.isSuccessfulBoot());
        PathAddress distributableEjbAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{DistributableEjbSubsystemResourceDefinitionRegistrar.REGISTRATION.getPathElement()});
        PathAddress anotherBeanManagementProviderAddress = distributableEjbAddress.append(new PathElement[]{BeanManagementResourceRegistration.INFINISPAN.pathElement("another-bean-management-provider")});
        ModelNode anotherBeanManagementProvider = Util.createAddOperation((PathAddress)anotherBeanManagementProviderAddress);
        anotherBeanManagementProvider.get(InfinispanBeanManagementResourceDefinitionRegistrar.CACHE_ATTRIBUTE_GROUP.getContainerAttribute().getName()).set("foo");
        anotherBeanManagementProvider.get(InfinispanBeanManagementResourceDefinitionRegistrar.CACHE_ATTRIBUTE_GROUP.getCacheAttribute().getName()).set("bar");
        anotherBeanManagementProvider.get(BeanManagementResourceDefinitionRegistrar.MAX_ACTIVE_BEANS.getName()).set(11);
        ModelNode addResponse = ks.executeOperation(anotherBeanManagementProvider, new InputStream[0]);
        Assert.assertEquals((String)addResponse.toString(), (Object)"success", (Object)addResponse.get("outcome").asString());
        ModelNode readMaxActiveBeansAttribute = Util.getReadAttributeOperation((PathAddress)anotherBeanManagementProviderAddress, (String)BeanManagementResourceDefinitionRegistrar.MAX_ACTIVE_BEANS.getName());
        ModelNode readMaxActiveBeansResult = ks.executeOperation(readMaxActiveBeansAttribute, new InputStream[0]);
        Assert.assertEquals((String)readMaxActiveBeansResult.toString(), (Object)"success", (Object)readMaxActiveBeansResult.get("outcome").asString());
        Assert.assertEquals((String)readMaxActiveBeansResult.toString(), (long)11L, (long)readMaxActiveBeansResult.get("result").asInt());
        ModelNode removeAnotherBeanManagementProvider = Util.createRemoveOperation((PathAddress)anotherBeanManagementProviderAddress);
        ModelNode removeResponse = ks.executeOperation(removeAnotherBeanManagementProvider, new InputStream[0]);
        Assert.assertEquals((String)removeResponse.toString(), (Object)"success", (Object)removeResponse.get("outcome").asString());
    }

    @Test
    public void testClientMappingsRegistry() throws Exception {
        String subsystemXml = this.getSubsystemXml();
        KernelServices ks = this.createKernelServicesBuilder(this.createAdditionalInitialization()).setSubsystemXml(subsystemXml).build();
        Assert.assertTrue((String)"Subsystem boot failed!", (boolean)ks.isSuccessfulBoot());
        PathAddress distributableEjbAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{DistributableEjbSubsystemResourceDefinitionRegistrar.REGISTRATION.getPathElement()});
        PathAddress infinispanClientMappingsRegistryProviderAddress = distributableEjbAddress.append(new PathElement[]{ClientMappingsRegistryProviderResourceRegistration.INFINISPAN.getPathElement()});
        ModelNode addInfinispanClientMappingsRegistryProvider = Util.createAddOperation((PathAddress)infinispanClientMappingsRegistryProviderAddress);
        addInfinispanClientMappingsRegistryProvider.get(InfinispanClientMappingsRegistryProviderResourceDefinitionRegistrar.CACHE_ATTRIBUTE_GROUP.getContainerAttribute().getName()).set("foo");
        addInfinispanClientMappingsRegistryProvider.get(InfinispanClientMappingsRegistryProviderResourceDefinitionRegistrar.CACHE_ATTRIBUTE_GROUP.getCacheAttribute().getName()).set("bar");
        ModelNode addResponse = ks.executeOperation(addInfinispanClientMappingsRegistryProvider, new InputStream[0]);
        Assert.assertEquals((String)addResponse.toString(), (Object)"success", (Object)addResponse.get("outcome").asString());
        ModelNode distributableEjbSubsystem = ks.readWholeModel().get(DistributableEjbSubsystemResourceDefinitionRegistrar.REGISTRATION.getPathElement().getKeyValuePair());
        ModelNode localClientMappingsRegistryProvider = distributableEjbSubsystem.get(ClientMappingsRegistryProviderResourceRegistration.LOCAL.getPathElement().getKeyValuePair());
        ModelNode infinispanClientMappingsRegistryProvider = distributableEjbSubsystem.get(ClientMappingsRegistryProviderResourceRegistration.INFINISPAN.getPathElement().getKeyValuePair());
        Assert.assertEquals((String)localClientMappingsRegistryProvider.toString(), (Object)false, (Object)localClientMappingsRegistryProvider.isDefined());
        Assert.assertEquals((String)infinispanClientMappingsRegistryProvider.toString(), (Object)true, (Object)infinispanClientMappingsRegistryProvider.isDefined());
    }

    @Test
    public void testExpressions() throws Exception {
        String subsystemXml = this.getSubsystemXml();
        KernelServices ks = this.createKernelServicesBuilder(this.createAdditionalInitialization()).setSubsystemXml(subsystemXml).build();
        Assert.assertTrue((String)"Subsystem boot failed!", (boolean)ks.isSuccessfulBoot());
        ModelNode subsystem = ks.readWholeModel().get(DistributableEjbSubsystemResourceDefinitionRegistrar.REGISTRATION.getPathElement().getKeyValuePair());
        ModelNode beanManagement = subsystem.get(BeanManagementResourceRegistration.INFINISPAN.pathElement("default").getKeyValuePair());
        int maxActiveBeans = beanManagement.get(BeanManagementResourceDefinitionRegistrar.MAX_ACTIVE_BEANS.getName()).resolve().asInt();
        Assert.assertEquals((long)10000L, (long)maxActiveBeans);
        ModelNode persistentTimerManagement = subsystem.get(new String[]{InfinispanTimerManagementResourceDefinitionRegistrar.REGISTRATION.getPathElement().getKey(), "distributed"});
        Assert.assertEquals((long)100L, (long)persistentTimerManagement.get(InfinispanTimerManagementResourceDefinitionRegistrar.MAX_ACTIVE_TIMERS.getName()).resolve().asInt());
        ModelNode transientTimerManagement = subsystem.get(new String[]{InfinispanTimerManagementResourceDefinitionRegistrar.REGISTRATION.getPathElement().getKey(), "transient"});
        Assert.assertEquals((long)1000L, (long)transientTimerManagement.get(InfinispanTimerManagementResourceDefinitionRegistrar.MAX_ACTIVE_TIMERS.getName()).resolve().asInt());
    }
}

