/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.affinity.KeyAffinityService;
import org.infinispan.affinity.KeyGenerator;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.notifications.cachelistener.annotation.DataRehashed;
import org.infinispan.notifications.cachelistener.event.CacheEntryActivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryPassivatedEvent;
import org.infinispan.notifications.cachelistener.event.DataRehashedEvent;
import org.infinispan.remoting.transport.Address;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.ClusterAffinity;
import org.jboss.ejb.client.NodeAffinity;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.dispatcher.CommandResponse;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Invoker;
import org.wildfly.clustering.ee.infinispan.InfinispanBatcher;
import org.wildfly.clustering.ee.infinispan.RetryingInvoker;
import org.wildfly.clustering.ee.infinispan.TransactionBatch;
import org.wildfly.clustering.ejb.Bean;
import org.wildfly.clustering.ejb.BeanManager;
import org.wildfly.clustering.ejb.IdentifierFactory;
import org.wildfly.clustering.ejb.RemoveListener;
import org.wildfly.clustering.ejb.Time;
import org.wildfly.clustering.ejb.infinispan.BeanEntry;
import org.wildfly.clustering.ejb.infinispan.BeanEvictionScheduler;
import org.wildfly.clustering.ejb.infinispan.BeanExpirationScheduler;
import org.wildfly.clustering.ejb.infinispan.BeanFactory;
import org.wildfly.clustering.ejb.infinispan.BeanGroup;
import org.wildfly.clustering.ejb.infinispan.BeanGroupEntry;
import org.wildfly.clustering.ejb.infinispan.BeanGroupFactory;
import org.wildfly.clustering.ejb.infinispan.BeanKey;
import org.wildfly.clustering.ejb.infinispan.BeanKeyFilter;
import org.wildfly.clustering.ejb.infinispan.CancelSchedulerCommand;
import org.wildfly.clustering.ejb.infinispan.Configuration;
import org.wildfly.clustering.ejb.infinispan.ExpirationConfiguration;
import org.wildfly.clustering.ejb.infinispan.ExpiredBeanRemover;
import org.wildfly.clustering.ejb.infinispan.InfinispanBeanManagerConfiguration;
import org.wildfly.clustering.ejb.infinispan.PassivationConfiguration;
import org.wildfly.clustering.ejb.infinispan.ScheduleSchedulerCommand;
import org.wildfly.clustering.ejb.infinispan.Scheduler;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.group.NodeFactory;
import org.wildfly.clustering.infinispan.spi.affinity.KeyAffinityServiceFactory;
import org.wildfly.clustering.infinispan.spi.distribution.ConsistentHashLocality;
import org.wildfly.clustering.infinispan.spi.distribution.Locality;
import org.wildfly.clustering.infinispan.spi.distribution.SimpleLocality;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.service.concurrent.ServiceExecutor;
import org.wildfly.clustering.service.concurrent.StampedLockServiceExecutor;

@Listener(primaryOnly=true)
public class InfinispanBeanManager<G, I, T>
implements BeanManager<G, I, T, TransactionBatch> {
    private final Cache<G, BeanGroupEntry<I, T>> groupCache;
    private final String beanName;
    private final Cache<BeanKey<I>, BeanEntry<G>> beanCache;
    private final BeanFactory<G, I, T> beanFactory;
    private final BeanGroupFactory<G, I, T> groupFactory;
    private final IdentifierFactory<G> groupIdentifierFactory;
    private final IdentifierFactory<I> beanIdentifierFactory;
    private final List<KeyAffinityService<?>> affinityServices = new ArrayList(2);
    private final Registry<String, ?> registry;
    private final NodeFactory<Address> nodeFactory;
    private final CommandDispatcherFactory dispatcherFactory;
    private final ExpirationConfiguration<T> expiration;
    private final PassivationConfiguration<T> passivation;
    private final AtomicInteger passiveCount = new AtomicInteger();
    private final Batcher<TransactionBatch> batcher;
    private final Invoker invoker = new RetryingInvoker(new long[]{0L, 10L, 100L});
    private final BeanKeyFilter<I> filter;
    private volatile CommandDispatcher<Scheduler<I>> dispatcher;
    private volatile Scheduler<I> scheduler;
    private volatile ServiceExecutor executor;

    public InfinispanBeanManager(InfinispanBeanManagerConfiguration<T> configuration, Configuration<I, BeanKey<I>, BeanEntry<G>, BeanFactory<G, I, T>> beanConfiguration, Configuration<G, G, BeanGroupEntry<I, T>, BeanGroupFactory<G, I, T>> groupConfiguration) {
        this.beanName = configuration.getBeanName();
        this.groupFactory = groupConfiguration.getFactory();
        this.beanFactory = beanConfiguration.getFactory();
        this.groupCache = groupConfiguration.getCache();
        this.beanCache = beanConfiguration.getCache();
        this.batcher = new InfinispanBatcher(this.groupCache);
        this.filter = new BeanKeyFilter(this.beanName);
        Address address = this.groupCache.getCacheManager().getAddress();
        KeyGenerator groupKeyGenerator = () -> groupConfiguration.getIdentifierFactory().createIdentifier();
        KeyAffinityServiceFactory affinityFactory = configuration.getAffinityFactory();
        KeyAffinityService groupAffinity = affinityFactory.createService(this.groupCache, groupKeyGenerator);
        this.groupIdentifierFactory = () -> groupAffinity.getKeyForAddress(address);
        this.affinityServices.add(groupAffinity);
        KeyGenerator beanKeyGenerator = () -> ((BeanFactory)beanConfiguration.getFactory()).createKey(beanConfiguration.getIdentifierFactory().createIdentifier());
        KeyAffinityService beanAffinity = affinityFactory.createService(this.beanCache, beanKeyGenerator);
        this.beanIdentifierFactory = () -> ((BeanKey)beanAffinity.getKeyForAddress(address)).getId();
        this.affinityServices.add(beanAffinity);
        this.registry = configuration.getRegistry();
        this.nodeFactory = configuration.getNodeFactory();
        this.dispatcherFactory = configuration.getCommandDispatcherFactory();
        this.expiration = configuration.getExpirationConfiguration();
        this.passivation = configuration.getPassivationConfiguration();
    }

    public void start() {
        this.executor = new StampedLockServiceExecutor();
        this.affinityServices.forEach(service -> service.start());
        final ArrayList schedulers = new ArrayList(2);
        Time timeout = this.expiration.getTimeout();
        if (timeout != null && timeout.getValue() >= 0L) {
            schedulers.add(new BeanExpirationScheduler(this.batcher, new ExpiredBeanRemover<G, I, T>(this.beanFactory), this.expiration));
        }
        if (this.passivation.isEvictionAllowed()) {
            schedulers.add(new BeanEvictionScheduler(this.beanName + ".eviction", this.batcher, this.beanFactory, this.dispatcherFactory, this.passivation));
        }
        this.scheduler = new Scheduler<I>(){

            @Override
            public void schedule(I id) {
                schedulers.forEach(scheduler -> scheduler.schedule(id));
            }

            @Override
            public void cancel(I id) {
                schedulers.forEach(scheduler -> scheduler.cancel(id));
            }

            @Override
            public void cancel(Locality locality) {
                schedulers.forEach(scheduler -> scheduler.cancel(locality));
            }

            @Override
            public void close() {
                schedulers.forEach(scheduler -> scheduler.close());
            }
        };
        this.dispatcher = this.dispatcherFactory.createCommandDispatcher((Object)(this.beanName + ".schedulers"), this.scheduler);
        this.beanCache.addListener((Object)this, this.filter);
        this.schedule(this.beanCache, (Locality)new SimpleLocality(false), (Locality)new ConsistentHashLocality(this.beanCache));
    }

    public void stop() {
        this.executor.close(() -> {
            this.beanCache.removeListener((Object)this);
            this.dispatcher.close();
            this.scheduler.close();
            this.affinityServices.forEach(service -> service.stop());
        });
    }

    public Affinity getStrictAffinity() {
        return this.beanCache.getCacheConfiguration().clustering().cacheMode().isClustered() ? new ClusterAffinity(this.registry.getGroup().getName()) : new NodeAffinity((String)this.registry.getLocalEntry().getKey());
    }

    public Affinity getWeakAffinity(I id) {
        return this.beanCache.getCacheConfiguration().clustering().cacheMode().isClustered() ? new NodeAffinity((String)this.registry.getEntry(this.locatePrimaryOwner(id)).getKey()) : Affinity.NONE;
    }

    private void cancel(Bean<G, I, T> bean) {
        try {
            this.executeOnPrimaryOwner(bean, new CancelSchedulerCommand<Object>(bean.getId()));
        }
        catch (Exception e) {
            InfinispanEjbLogger.ROOT_LOGGER.failedToCancelBean(e, bean.getId());
        }
    }

    void schedule(Bean<G, I, T> bean) {
        try {
            this.executeOnPrimaryOwner(bean, new ScheduleSchedulerCommand<Object>(bean.getId()));
        }
        catch (Exception e) {
            InfinispanEjbLogger.ROOT_LOGGER.failedToScheduleBean(e, bean.getId());
        }
    }

    private void executeOnPrimaryOwner(Bean<G, I, T> bean, Command<Void, Scheduler<I>> command) throws Exception {
        ((CommandResponse)this.invoker.invoke(() -> {
            Node node = this.locatePrimaryOwner(bean.getId());
            return this.dispatcher.executeOnNode(command, node);
        })).get();
    }

    Node locatePrimaryOwner(I id) {
        DistributionManager dist = this.beanCache.getAdvancedCache().getDistributionManager();
        Address address = dist != null ? dist.getPrimaryLocation(id) : null;
        return address != null ? this.nodeFactory.createNode((Object)address) : this.registry.getGroup().getLocalNode();
    }

    public Bean<G, I, T> createBean(I id, G groupId, T bean) {
        InfinispanEjbLogger.ROOT_LOGGER.tracef("Creating bean %s associated with group %s", id, groupId);
        BeanGroup<G, I, T> group = this.groupFactory.createGroup(groupId, (BeanGroupEntry)this.groupFactory.createValue(groupId, null));
        group.addBean(id, bean);
        group.releaseBean(id, this.passivation.isPersistent() ? this.passivation.getPassivationListener() : null);
        return new SchedulableBean(this.beanFactory.createBean(id, (BeanEntry)this.beanFactory.createValue(id, groupId)));
    }

    public Bean<G, I, T> findBean(I id) {
        InfinispanEjbLogger.ROOT_LOGGER.tracef("Locating bean %s", id);
        BeanEntry entry = (BeanEntry)this.beanFactory.findValue(id);
        if (entry == null) {
            InfinispanEjbLogger.ROOT_LOGGER.debugf("Could not find bean %s", id);
            return null;
        }
        Bean<G, I, T> bean = this.beanFactory.createBean(id, entry);
        this.cancel(bean);
        return new SchedulableBean(bean);
    }

    public boolean containsBean(I id) {
        return this.beanCache.containsKey(this.beanFactory.createKey(id));
    }

    public IdentifierFactory<G> getGroupIdentifierFactory() {
        return this.groupIdentifierFactory;
    }

    public IdentifierFactory<I> getBeanIdentifierFactory() {
        return this.beanIdentifierFactory;
    }

    public Batcher<TransactionBatch> getBatcher() {
        return this.batcher;
    }

    public int getActiveCount() {
        try (CacheStream keys = this.beanCache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD}).keySet().stream();){
            int n = (int)keys.filter(this.filter).count();
            return n;
        }
    }

    public int getPassiveCount() {
        return this.passiveCount.get();
    }

    @CacheEntryPassivated
    public void passivated(CacheEntryPassivatedEvent<BeanKey<I>, BeanEntry<G>> event) {
        if (event.isPre()) {
            this.passiveCount.incrementAndGet();
            if (!this.passivation.isPersistent()) {
                this.executor.execute(() -> {
                    Object groupId = ((BeanEntry)event.getValue()).getGroupId();
                    BeanGroupEntry entry = (BeanGroupEntry)this.groupFactory.findValue(groupId);
                    if (entry != null) {
                        try (BeanGroup group = this.groupFactory.createGroup(groupId, entry);){
                            group.prePassivate(((BeanKey)event.getKey()).getId(), this.passivation.getPassivationListener());
                        }
                    }
                });
            }
        }
    }

    @CacheEntryActivated
    public void activated(CacheEntryActivatedEvent<BeanKey<I>, BeanEntry<G>> event) {
        if (!event.isPre()) {
            this.passiveCount.decrementAndGet();
            if (!this.passivation.isPersistent()) {
                this.executor.execute(() -> {
                    Object groupId = ((BeanEntry)event.getValue()).getGroupId();
                    BeanGroupEntry entry = (BeanGroupEntry)this.groupFactory.findValue(groupId);
                    if (entry != null) {
                        try (BeanGroup group = this.groupFactory.createGroup(groupId, entry);){
                            group.postActivate(((BeanKey)event.getKey()).getId(), this.passivation.getPassivationListener());
                        }
                    }
                });
            }
        }
    }

    @DataRehashed
    public void dataRehashed(DataRehashedEvent<BeanKey<I>, BeanEntry<G>> event) {
        this.executor.execute(() -> {
            Cache cache = event.getCache();
            Address localAddress = cache.getCacheManager().getAddress();
            ConsistentHashLocality oldLocality = new ConsistentHashLocality(localAddress, event.getConsistentHashAtStart());
            ConsistentHashLocality newLocality = new ConsistentHashLocality(localAddress, event.getConsistentHashAtEnd());
            if (event.isPre()) {
                this.scheduler.cancel((Locality)newLocality);
            } else {
                this.schedule(cache, (Locality)oldLocality, (Locality)newLocality);
            }
        });
    }

    private void schedule(Cache<BeanKey<I>, BeanEntry<G>> cache, Locality oldLocality, Locality newLocality) {
        try (CacheStream stream = this.beanCache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD}).keySet().stream();){
            stream.filter(this.filter).map(key -> key.getId()).filter(id -> !oldLocality.isLocal(id) && newLocality.isLocal(id)).forEach(id -> this.scheduler.schedule(id));
        }
    }

    private class SchedulableBean
    implements Bean<G, I, T> {
        private final Bean<G, I, T> bean;

        SchedulableBean(Bean<G, I, T> bean) {
            this.bean = bean;
        }

        public I getId() {
            return this.bean.getId();
        }

        public G getGroupId() {
            return this.bean.getGroupId();
        }

        public void remove(RemoveListener<T> listener) {
            this.bean.remove(listener);
        }

        public boolean isExpired() {
            return this.bean.isExpired();
        }

        public T acquire() {
            return this.bean.acquire();
        }

        public boolean release() {
            return this.bean.release();
        }

        public void close() {
            this.bean.close();
            InfinispanBeanManager.this.schedule(this.bean);
        }
    }
}

