/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.bean;

import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.infinispan.CacheEntryMutator;
import org.wildfly.clustering.ee.infinispan.CacheProperties;
import org.wildfly.clustering.ejb.Bean;
import org.wildfly.clustering.ejb.PassivationListener;
import org.wildfly.clustering.ejb.RemoveListener;
import org.wildfly.clustering.ejb.Time;
import org.wildfly.clustering.ejb.infinispan.BeanEntry;
import org.wildfly.clustering.ejb.infinispan.BeanFactory;
import org.wildfly.clustering.ejb.infinispan.BeanGroup;
import org.wildfly.clustering.ejb.infinispan.BeanGroupEntry;
import org.wildfly.clustering.ejb.infinispan.BeanGroupFactory;
import org.wildfly.clustering.ejb.infinispan.BeanKey;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBean;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanEntry;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanKey;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;

public class InfinispanBeanFactory<I, T>
implements BeanFactory<I, T> {
    private final String beanName;
    private final BeanGroupFactory<I, T> groupFactory;
    private final Cache<BeanKey<I>, BeanEntry<I>> cache;
    private final Cache<BeanKey<I>, BeanEntry<I>> findCache;
    private final Time timeout;
    private final PassivationListener<T> listener;

    public InfinispanBeanFactory(String beanName, BeanGroupFactory<I, T> groupFactory, Cache<BeanKey<I>, BeanEntry<I>> cache, CacheProperties properties, Time timeout, PassivationListener<T> listener) {
        this.beanName = beanName;
        this.groupFactory = groupFactory;
        this.cache = cache;
        this.findCache = properties.isLockOnRead() ? this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_WRITE_LOCK}) : this.cache;
        this.timeout = timeout;
        this.listener = listener;
    }

    @Override
    public BeanKey<I> createKey(I id) {
        return new InfinispanBeanKey<I>(id);
    }

    @Override
    public Bean<I, T> createBean(I id, BeanEntry<I> entry) {
        I groupId = entry.getGroupId();
        BeanGroupEntry groupEntry = (BeanGroupEntry)this.groupFactory.findValue(groupId);
        if (groupEntry == null) {
            InfinispanEjbLogger.ROOT_LOGGER.invalidBeanGroup(id, groupId);
            this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove(this.createKey(id));
            return null;
        }
        BeanGroup<I, T> group = this.groupFactory.createGroup(groupId, groupEntry);
        Mutator mutator = entry.getLastAccessedTime() == null ? Mutator.PASSIVE : new CacheEntryMutator(this.cache, this.createKey(id), entry);
        return new InfinispanBean<I, T>(id, entry, group, mutator, this, this.timeout, this.listener);
    }

    public BeanEntry<I> findValue(I id) {
        return (BeanEntry)this.findCache.get(this.createKey(id));
    }

    public BeanEntry<I> tryValue(I id) {
        return (BeanEntry)this.findCache.getAdvancedCache().withFlags(new Flag[]{Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.FAIL_SILENTLY}).get(this.createKey(id));
    }

    public BeanEntry<I> createValue(I id, I groupId) {
        return (BeanEntry)this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).computeIfAbsent(this.createKey(id), key -> new InfinispanBeanEntry<Object>(this.beanName, groupId));
    }

    @Override
    public void remove(I id, RemoveListener<T> listener) {
        Object groupId;
        BeanGroupEntry groupEntry;
        BeanEntry entry = (BeanEntry)this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).remove(this.createKey(id));
        if (entry != null && (groupEntry = (BeanGroupEntry)this.groupFactory.findValue(groupId = entry.getGroupId())) != null) {
            try (BeanGroup<I, T> group = this.groupFactory.createGroup(groupId, groupEntry);){
                T bean = group.removeBean(id);
                if (listener != null) {
                    listener.removed(bean);
                }
            }
        }
    }
}

