/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.group;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.infinispan.CacheEntryMutator;
import org.wildfly.clustering.ee.infinispan.CacheProperties;
import org.wildfly.clustering.ejb.infinispan.BeanEntry;
import org.wildfly.clustering.ejb.infinispan.BeanGroup;
import org.wildfly.clustering.ejb.infinispan.BeanGroupEntry;
import org.wildfly.clustering.ejb.infinispan.BeanGroupFactory;
import org.wildfly.clustering.ejb.infinispan.BeanGroupKey;
import org.wildfly.clustering.ejb.infinispan.BeanKey;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanKey;
import org.wildfly.clustering.ejb.infinispan.group.InfinispanBeanGroup;
import org.wildfly.clustering.ejb.infinispan.group.InfinispanBeanGroupEntry;
import org.wildfly.clustering.ejb.infinispan.group.InfinispanBeanGroupKey;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;
import org.wildfly.clustering.marshalling.jboss.MarshallingContext;
import org.wildfly.clustering.marshalling.spi.MarshalledValueFactory;

public class InfinispanBeanGroupFactory<I, T>
implements BeanGroupFactory<I, T> {
    private final Cache<BeanGroupKey<I>, BeanGroupEntry<I, T>> cache;
    private final Cache<BeanGroupKey<I>, BeanGroupEntry<I, T>> findCache;
    private final Cache<BeanKey<I>, BeanEntry<I>> beanCache;
    private final MarshalledValueFactory<MarshallingContext> factory;
    private final MarshallingContext context;

    public InfinispanBeanGroupFactory(Cache<BeanGroupKey<I>, BeanGroupEntry<I, T>> cache, Cache<BeanKey<I>, BeanEntry<I>> beanCache, MarshalledValueFactory<MarshallingContext> factory, MarshallingContext context, CacheProperties properties) {
        this.cache = cache;
        this.findCache = properties.isLockOnRead() ? cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_WRITE_LOCK}) : cache;
        this.beanCache = properties.isLockOnRead() ? beanCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_WRITE_LOCK}) : beanCache;
        this.factory = factory;
        this.context = context;
    }

    @Override
    public BeanGroupKey<I> createKey(I id) {
        return new InfinispanBeanGroupKey<I>(id);
    }

    public BeanGroupEntry<I, T> createValue(I id, Void context) {
        return (BeanGroupEntry)this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).computeIfAbsent(this.createKey(id), key -> new InfinispanBeanGroupEntry(this.factory.createMarshalledValue(new ConcurrentHashMap())));
    }

    public BeanGroupEntry<I, T> findValue(I id) {
        return (BeanGroupEntry)this.findCache.get(this.createKey(id));
    }

    public BeanGroupEntry<I, T> tryValue(I id) {
        return (BeanGroupEntry)this.findCache.getAdvancedCache().withFlags(new Flag[]{Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.FAIL_SILENTLY}).get(this.createKey(id));
    }

    public boolean evict(I id) {
        BeanGroupKey<I> key = this.createKey(id);
        BeanGroupEntry entry = (BeanGroupEntry)this.findCache.getAdvancedCache().withFlags(EVICTION_FLAGS).get(key);
        if (entry != null) {
            try {
                for (Object beanId : ((Map)entry.getBeans().get((Object)this.context)).keySet()) {
                    this.beanCache.evict(new InfinispanBeanKey(beanId));
                }
                try {
                    this.cache.evict(key);
                }
                catch (Throwable e) {
                    InfinispanEjbLogger.ROOT_LOGGER.failedToPassivateBeanGroup(e, id);
                }
            }
            catch (Exception e) {
                InfinispanEjbLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
            }
        }
        return entry != null;
    }

    public boolean remove(I id) {
        this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove(id);
        return true;
    }

    @Override
    public BeanGroup<I, T> createGroup(I id, BeanGroupEntry<I, T> entry) {
        CacheEntryMutator mutator = new CacheEntryMutator(this.cache, this.createKey(id), entry);
        return new InfinispanBeanGroup<I, T>(id, entry, this.context, (Mutator)mutator, this);
    }
}

