/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.util.Collection;
import java.util.LinkedList;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationChildBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.spi.service.CacheServiceConfigurator;
import org.wildfly.clustering.infinispan.spi.service.TemplateConfigurationServiceConfigurator;
import org.wildfly.clustering.spi.CacheServiceConfiguratorProvider;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;
import org.wildfly.clustering.spi.IdentityCacheServiceConfiguratorProvider;
import org.wildfly.clustering.spi.ServiceNameRegistry;

public class ClientMappingsCacheServiceConfiguratorProvider
implements CacheServiceConfiguratorProvider,
IdentityCacheServiceConfiguratorProvider,
Consumer<ConfigurationBuilder> {
    private final Class<? extends CacheServiceConfiguratorProvider> providerClass;

    ClientMappingsCacheServiceConfiguratorProvider(Class<? extends CacheServiceConfiguratorProvider> providerClass) {
        this.providerClass = providerClass;
    }

    public Collection<CapabilityServiceConfigurator> getServiceConfigurators(ServiceNameRegistry<ClusteringCacheRequirement> registry, String containerName, String aliasCacheName) {
        LinkedList<CapabilityServiceConfigurator> configurators = new LinkedList<CapabilityServiceConfigurator>();
        if (aliasCacheName == null) {
            String cacheName = "client-mappings";
            configurators.add((CapabilityServiceConfigurator)new TemplateConfigurationServiceConfigurator(ServiceName.parse((String)InfinispanCacheRequirement.CONFIGURATION.resolve(containerName, cacheName)), containerName, cacheName, aliasCacheName, (Consumer)this));
            configurators.add((CapabilityServiceConfigurator)new CacheServiceConfigurator(ServiceName.parse((String)InfinispanCacheRequirement.CACHE.resolve(containerName, cacheName)), containerName, cacheName));
            ServiceNameRegistry routingRegistry = requirement -> ServiceName.parse((String)requirement.resolve(containerName, cacheName));
            for (CacheServiceConfiguratorProvider cacheServiceConfiguratorProvider : ServiceLoader.load(this.providerClass, this.providerClass.getClassLoader())) {
                configurators.addAll(cacheServiceConfiguratorProvider.getServiceConfigurators(routingRegistry, containerName, cacheName));
            }
        }
        return configurators;
    }

    public Collection<CapabilityServiceConfigurator> getServiceConfigurators(ServiceNameRegistry<ClusteringCacheRequirement> registry, String containerName, String cacheName, String targetCacheName) {
        return this.getServiceConfigurators(registry, containerName, cacheName);
    }

    @Override
    public void accept(ConfigurationBuilder builder) {
        ClusteringConfigurationBuilder clustering;
        CacheMode mode = (clustering = builder.clustering()).cacheMode();
        clustering.cacheMode(mode.isClustered() ? CacheMode.REPL_SYNC : CacheMode.LOCAL);
        clustering.hash().consistentHashFactory(null);
        clustering.l1().disable();
        AttributeSet attributes = TemplateConfigurationServiceConfigurator.getAttributes((ConfigurationChildBuilder)clustering);
        attributes.attribute(ClusteringConfiguration.BIAS_ACQUISITION).reset();
        attributes.attribute(ClusteringConfiguration.BIAS_LIFESPAN).reset();
        attributes.attribute(ClusteringConfiguration.INVALIDATION_BATCH_SIZE).reset();
        builder.dataContainer().dataContainer(null);
        builder.expiration().lifespan(-1L).maxIdle(-1L);
        builder.memory().size(-1L).evictionStrategy(EvictionStrategy.MANUAL);
        builder.persistence().clearStores();
    }
}

