/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.wildfly.clustering.ejb.infinispan.BeanEntry;
import org.wildfly.clustering.ejb.infinispan.BeanFactory;
import org.wildfly.clustering.ejb.infinispan.BeanGroupEvictor;
import org.wildfly.clustering.ejb.infinispan.ExpirationTracker;
import org.wildfly.clustering.ejb.infinispan.ImmutableBeanEntry;
import org.wildfly.clustering.ejb.infinispan.Scheduler;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;
import org.wildfly.clustering.infinispan.spi.distribution.Locality;

public class NonClusteredEagerEvictionScheduler<I, T>
implements Scheduler<I>,
BeanGroupEvictor<I>,
Consumer<I> {
    private final BeanFactory<I, T> factory;
    private final ScheduledExecutorService executor;
    private final Duration idleTimeout;
    private final ExpirationTracker<I> expirationTracker;
    private final Map<I, I> groupIdMap = new HashMap<I, I>();
    private volatile Future<?> evictionTask;
    private final BeanGroupEvictor<I> evictor;

    NonClusteredEagerEvictionScheduler(BeanFactory<I, T> factory, BeanGroupEvictor<I> evictor, ScheduledExecutorService executor, Duration idleTimeout) {
        this.factory = factory;
        this.executor = executor;
        this.idleTimeout = idleTimeout;
        this.expirationTracker = new ExpirationTracker(idleTimeout);
        this.evictor = evictor;
    }

    @Override
    public void accept(I id) {
        this.expirationTracker.forget(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(I id) {
        BeanEntry entry = (BeanEntry)this.factory.findValue(id);
        if (entry != null) {
            InfinispanEjbLogger.ROOT_LOGGER.tracef("Scheduling stateful session bean %s to passivate in %s", id, this.idleTimeout);
            this.expirationTracker.trackExpiration(id);
            if (!this.groupIdMap.containsKey(id)) {
                this.groupIdMap.put(id, entry.getGroupId());
            }
            if (this.evictionTask == null) {
                NonClusteredEagerEvictionScheduler nonClusteredEagerEvictionScheduler = this;
                synchronized (nonClusteredEagerEvictionScheduler) {
                    if (this.evictionTask == null) {
                        EvictionTask task = new EvictionTask();
                        this.evictionTask = this.executor.schedule(task, this.idleTimeout.toMillis(), TimeUnit.MILLISECONDS);
                    }
                }
            }
        }
    }

    @Override
    public void schedule(I id, ImmutableBeanEntry<I> entry) {
        this.schedule(id);
    }

    @Override
    public void prepareRescheduling(I id) {
        this.expirationTracker.invalidateExpiration(id);
    }

    @Override
    public void cancel(I id) {
        this.expirationTracker.forget(id);
        this.groupIdMap.remove(id);
    }

    @Override
    public void cancel(Locality locality) {
        for (I id : this.expirationTracker.getTrackedIds()) {
            if (Thread.currentThread().isInterrupted()) break;
            if (locality.isLocal(id)) continue;
            this.cancel(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Future<?> task;
        NonClusteredEagerEvictionScheduler nonClusteredEagerEvictionScheduler = this;
        synchronized (nonClusteredEagerEvictionScheduler) {
            if (this.evictionTask == null) {
                return;
            }
            task = this.evictionTask;
        }
        task.cancel(false);
        if (!task.isDone()) {
            try {
                task.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
    }

    @Override
    public void evict(I id) {
        InfinispanEjbLogger.ROOT_LOGGER.tracef("Passivating stateful session bean %s", id);
        this.evictor.evict(id);
    }

    private class EvictionTask
    implements Runnable {
        private EvictionTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object sessionId;
            long currentTime = System.currentTimeMillis();
            while ((sessionId = NonClusteredEagerEvictionScheduler.this.expirationTracker.getExpiredId(currentTime)) != null) {
                InfinispanEjbLogger.ROOT_LOGGER.tracef("Evicting stateful session bean %s", sessionId);
                Object groupId = NonClusteredEagerEvictionScheduler.this.groupIdMap.remove(sessionId);
                try {
                    NonClusteredEagerEvictionScheduler.this.evict(groupId);
                }
                finally {
                    NonClusteredEagerEvictionScheduler nonClusteredEagerEvictionScheduler = NonClusteredEagerEvictionScheduler.this;
                    synchronized (nonClusteredEagerEvictionScheduler) {
                        NonClusteredEagerEvictionScheduler.this.accept(sessionId);
                    }
                }
            }
            long nextExpirationInMillis = NonClusteredEagerEvictionScheduler.this.expirationTracker.getNextExpirationInMillis();
            NonClusteredEagerEvictionScheduler nonClusteredEagerEvictionScheduler = NonClusteredEagerEvictionScheduler.this;
            synchronized (nonClusteredEagerEvictionScheduler) {
                if (nextExpirationInMillis != -1L) {
                    NonClusteredEagerEvictionScheduler.this.evictionTask = NonClusteredEagerEvictionScheduler.this.executor.schedule(this, nextExpirationInMillis - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                } else {
                    NonClusteredEagerEvictionScheduler.this.evictionTask = null;
                }
            }
        }
    }
}

