/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandDispatcherException;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.cache.scheduler.LinkedScheduledEntries;
import org.wildfly.clustering.ee.cache.scheduler.LocalScheduler;
import org.wildfly.clustering.ee.cache.scheduler.ScheduledEntries;
import org.wildfly.clustering.ee.cache.scheduler.SortedScheduledEntries;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ee.infinispan.scheduler.Scheduler;
import org.wildfly.clustering.ejb.infinispan.BeanEntry;
import org.wildfly.clustering.ejb.infinispan.BeanFactory;
import org.wildfly.clustering.ejb.infinispan.BeanGroupEvictor;
import org.wildfly.clustering.ejb.infinispan.ImmutableBeanEntry;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanKey;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.infinispan.spi.distribution.Locality;

public class EagerEvictionScheduler<I, T>
implements Scheduler<I, ImmutableBeanEntry<I>>,
Predicate<I> {
    private final LocalScheduler<I> scheduler;
    private final Batcher<TransactionBatch> batcher;
    private final Map<I, I> beanGroups = new ConcurrentHashMap<I, I>();
    private final BeanFactory<I, T> factory;
    private final Duration idleTimeout;
    private final CommandDispatcher<BeanGroupEvictor<I>> dispatcher;

    public EagerEvictionScheduler(Group group, Batcher<TransactionBatch> batcher, BeanFactory<I, T> factory, BeanGroupEvictor<I> evictor, Duration idleTimeout, CommandDispatcherFactory dispatcherFactory, String dispatcherName, Duration closeTimeout) {
        this.scheduler = new LocalScheduler((ScheduledEntries)(group.isSingleton() ? new LinkedScheduledEntries() : new SortedScheduledEntries()), (Predicate)this, closeTimeout);
        this.batcher = batcher;
        this.factory = factory;
        this.idleTimeout = idleTimeout;
        this.dispatcher = dispatcherFactory.createCommandDispatcher((Object)(dispatcherName + "/eviction"), evictor);
    }

    public void schedule(I id) {
        try (Batch batch = this.batcher.createBatch();){
            BeanEntry entry = (BeanEntry)this.factory.findValue(id);
            if (entry != null) {
                this.schedule(id, entry);
            }
        }
    }

    public void schedule(I id, ImmutableBeanEntry<I> entry) {
        InfinispanEjbLogger.ROOT_LOGGER.tracef("Scheduling stateful session bean %s to passivate in %s", id, this.idleTimeout);
        this.beanGroups.put(id, entry.getGroupId());
        this.scheduler.schedule(id, Instant.now().plus(this.idleTimeout));
    }

    public void cancel(I id) {
        this.scheduler.cancel(id);
        this.beanGroups.remove(id);
    }

    public void cancel(Locality locality) {
        for (Object id : this.scheduler) {
            if (Thread.currentThread().isInterrupted()) break;
            if (locality.isLocal(new InfinispanBeanKey(id))) continue;
            this.cancel(id);
        }
    }

    public void close() {
        this.scheduler.close();
        this.dispatcher.close();
    }

    @Override
    public boolean test(I id) {
        InfinispanEjbLogger.ROOT_LOGGER.debugf("Evicting stateful session bean %s", id);
        try {
            this.dispatcher.executeOnGroup(new EvictCommand<I>(id), new Node[0]);
            this.beanGroups.remove(id);
            return true;
        }
        catch (CommandDispatcherException e) {
            InfinispanEjbLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
            return false;
        }
    }

    static class EvictCommand<I>
    implements Command<Void, BeanGroupEvictor<I>> {
        private static final long serialVersionUID = -7382608648983713382L;
        private final I id;

        EvictCommand(I id) {
            this.id = id;
        }

        public Void execute(BeanGroupEvictor<I> evictor) throws Exception {
            InfinispanEjbLogger.ROOT_LOGGER.tracef("Passivating stateful session bean %s", this.id);
            evictor.evict(this.id);
            return null;
        }
    }
}

