package org.wildfly.clustering.ejb.infinispan.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2020-11-19T16:24:37-0600")
public class InfinispanEjbLogger_$logger extends DelegatingBasicLogger implements InfinispanEjbLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = InfinispanEjbLogger_$logger.class.getName();
    public InfinispanEjbLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void failedToPassivateBean(final Throwable cause, final Object id) {
        super.log.logf(FQCN, WARN, cause, failedToPassivateBean$str(), id);
    }
    protected String failedToPassivateBean$str() {
        return "WFLYCLEJBINF0001: Failed to passivate stateful session bean %s";
    }
    @Override
    public final void failedToPassivateBeanGroup(final Throwable cause, final Object id) {
        super.log.logf(FQCN, WARN, cause, failedToPassivateBeanGroup$str(), id);
    }
    protected String failedToPassivateBeanGroup$str() {
        return "WFLYCLEJBINF0002: Failed to passivate stateful session bean group %s";
    }
    @Override
    public final void failedToExpireBean(final Throwable cause, final Object id) {
        super.log.logf(FQCN, WARN, cause, failedToExpireBean$str(), id);
    }
    protected String failedToExpireBean$str() {
        return "WFLYCLEJBINF0003: Failed to expire stateful session bean %s";
    }
    protected String deserializationFailure$str() {
        return "WFLYCLEJBINF0004: Failed to deserialize %s";
    }
    @Override
    public final IllegalStateException deserializationFailure(final Throwable cause, final Object key) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), deserializationFailure$str(), key), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void failedToCancelBean(final Throwable cause, final Object beanId) {
        super.log.logf(FQCN, DEBUG, cause, failedToCancelBean$str(), beanId);
    }
    protected String failedToCancelBean$str() {
        return "WFLYCLEJBINF0005: Failed to cancel expiration/passivation of bean %s on primary owner.";
    }
    @Override
    public final void failedToScheduleBean(final Throwable cause, final Object beanId) {
        super.log.logf(FQCN, DEBUG, cause, failedToScheduleBean$str(), beanId);
    }
    protected String failedToScheduleBean$str() {
        return "WFLYCLEJBINF0006: Failed to schedule expiration/passivation of bean %s on primary owner.";
    }
    @Override
    public final void invalidBeanGroup(final Object beanId, final Object groupId) {
        super.log.logf(FQCN, WARN, null, invalidBeanGroup$str(), beanId, groupId);
    }
    protected String invalidBeanGroup$str() {
        return "WFLYCLEJBINF0008: Stateful session bean %s refers to an invalid bean group %s";
    }
    @Override
    public final void evictionDisabled(final String cacheName) {
        super.log.logf(FQCN, WARN, null, evictionDisabled$str(), cacheName);
    }
    protected String evictionDisabled$str() {
        return "WFLYCLEJBINF0009: Disabling eviction for cache '%s'. SFSB passivation should be configured via the associated EJB subsystem passivation-store.";
    }
    @Override
    public final void expirationDisabled(final String cacheName) {
        super.log.logf(FQCN, WARN, null, expirationDisabled$str(), cacheName);
    }
    protected String expirationDisabled$str() {
        return "WFLYCLEJBINF0010: Disabling expiration for '%s'. SFSB expiration should be configured per §4.3.11 of the EJB specification.";
    }
}
