/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.bean;

import java.time.Duration;
import java.time.Instant;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ejb.Bean;
import org.wildfly.clustering.ejb.PassivationListener;
import org.wildfly.clustering.ejb.RemoveListener;
import org.wildfly.clustering.ejb.infinispan.BeanEntry;
import org.wildfly.clustering.ejb.infinispan.BeanGroup;
import org.wildfly.clustering.ejb.infinispan.BeanRemover;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBean;

public class InfinispanBeanTestCase {
    private final String id = "id";
    private final BeanEntry<String> entry = (BeanEntry)Mockito.mock(BeanEntry.class);
    private final BeanGroup<String, Object> group = (BeanGroup)Mockito.mock(BeanGroup.class);
    private final Mutator mutator = (Mutator)Mockito.mock(Mutator.class);
    private final BeanRemover<String, Object> remover = (BeanRemover)Mockito.mock(BeanRemover.class);
    private final Duration timeout = Duration.ofMinutes(1L);
    private final PassivationListener<Object> listener = (PassivationListener)Mockito.mock(PassivationListener.class);
    private final Bean<String, Object> bean = new InfinispanBean((Object)this.id, this.entry, this.group, this.mutator, this.remover, this.timeout, this.listener);

    @After
    public void tearDown() {
        Mockito.reset((Object[])new Object[]{this.entry, this.group, this.remover, this.listener});
    }

    @Test
    public void getId() {
        Assert.assertSame((Object)this.id, (Object)this.bean.getId());
    }

    @Test
    public void getGroupId() {
        String groupId = "group";
        Mockito.when((Object)((String)this.entry.getGroupId())).thenReturn((Object)groupId);
        String result = (String)this.bean.getGroupId();
        Assert.assertSame((Object)groupId, (Object)result);
    }

    @Test
    public void acquire() {
        Object value = new Object();
        Mockito.when((Object)this.group.getBean((Object)this.id, this.listener)).thenReturn(value);
        Object result = this.bean.acquire();
        Assert.assertSame((Object)value, (Object)result);
    }

    @Test
    public void release() {
        this.bean.release();
        ((BeanGroup)Mockito.verify(this.group)).releaseBean((Object)this.id, this.listener);
    }

    @Test
    public void isExpired() {
        Mockito.when((Object)this.entry.getLastAccessedTime()).thenReturn((Object)Instant.now().minus(Duration.ofMinutes(2L)));
        Mockito.when((Object)this.entry.isExpired(this.timeout)).thenCallRealMethod();
        Mockito.when((Object)this.group.isCloseable()).thenReturn((Object)true, (Object[])new Boolean[]{false, true});
        Assert.assertTrue((boolean)this.bean.isExpired());
        Assert.assertFalse((boolean)this.bean.isExpired());
        Mockito.when((Object)this.entry.getLastAccessedTime()).thenReturn((Object)Instant.now());
        Assert.assertFalse((boolean)this.bean.isExpired());
        BeanEntry entry = (BeanEntry)Mockito.mock(BeanEntry.class);
        Mockito.when((Object)entry.isExpired((Duration)Mockito.any())).thenCallRealMethod();
        Assert.assertFalse((boolean)entry.isExpired(null));
        Assert.assertFalse((boolean)entry.isExpired(Duration.ofMillis(-1L)));
        Assert.assertTrue((boolean)entry.isExpired(Duration.ZERO));
        Mockito.when((Object)entry.getLastAccessedTime()).thenReturn(null);
        Assert.assertFalse((boolean)entry.isExpired(this.timeout));
        Mockito.when((Object)entry.getLastAccessedTime()).thenReturn((Object)Instant.now());
        Assert.assertFalse((boolean)entry.isExpired(this.timeout));
        Mockito.when((Object)entry.getLastAccessedTime()).thenReturn((Object)Instant.now().minus(this.timeout));
        Assert.assertTrue((boolean)entry.isExpired(this.timeout));
    }

    @Test
    public void remove() {
        RemoveListener listener = (RemoveListener)Mockito.mock(RemoveListener.class);
        Mockito.when((Object)this.group.isCloseable()).thenReturn((Object)false);
        this.bean.remove(listener);
        ((BeanRemover)Mockito.verify(this.remover)).remove((Object)this.id, listener);
        this.bean.remove(listener);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.remover});
    }

    @Test
    public void close() {
        Mockito.when((Object)this.entry.getLastAccessedTime()).thenReturn(null);
        Mockito.when((Object)this.group.isCloseable()).thenReturn((Object)false);
        this.bean.close();
        ((BeanEntry)Mockito.verify(this.entry)).setLastAccessedTime((Instant)ArgumentMatchers.any());
        ((Mutator)Mockito.verify((Object)this.mutator, (VerificationMode)Mockito.never())).mutate();
        ((BeanGroup)Mockito.verify(this.group, (VerificationMode)Mockito.never())).close();
        Mockito.reset((Object[])new Object[]{this.entry, this.mutator, this.group});
        Mockito.when((Object)this.entry.getLastAccessedTime()).thenReturn((Object)Instant.now());
        Mockito.when((Object)this.group.isCloseable()).thenReturn((Object)true);
        this.bean.close();
        ((BeanEntry)Mockito.verify(this.entry)).setLastAccessedTime((Instant)ArgumentMatchers.any());
        ((Mutator)Mockito.verify((Object)this.mutator)).mutate();
        ((BeanGroup)Mockito.verify(this.group)).close();
    }
}

