/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.group;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.UUIDSessionID;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.ejb.infinispan.group.InfinispanBeanGroupEntry;
import org.wildfly.clustering.marshalling.MarshallingTester;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamTesterFactory;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshalledValue;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.spi.JavaByteBufferMarshaller;
import org.wildfly.clustering.marshalling.spi.MarshalledValue;

public class InfinispanBeanGroupEntryMarshallerTestCase {
    @Test
    public void test() throws IOException {
        UUIDSessionID id = new UUIDSessionID(UUID.randomUUID());
        Map<UUIDSessionID, String> beans = Collections.singletonMap(id, "bean");
        InfinispanBeanGroupEntry entry = new InfinispanBeanGroupEntry((MarshalledValue)new ByteBufferMarshalledValue(beans, (ByteBufferMarshaller)JavaByteBufferMarshaller.INSTANCE));
        MarshallingTester tester = ProtoStreamTesterFactory.INSTANCE.createTester();
        tester.test((Object)entry, InfinispanBeanGroupEntryMarshallerTestCase::assertEquals);
    }

    static void assertEquals(InfinispanBeanGroupEntry<SessionID, String, ByteBufferMarshaller> entry1, InfinispanBeanGroupEntry<SessionID, String, ByteBufferMarshaller> entry2) {
        try {
            Assert.assertEquals((Object)entry1.getBeans().get((Object)JavaByteBufferMarshaller.INSTANCE), (Object)entry2.getBeans().get((Object)JavaByteBufferMarshaller.INSTANCE));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

