/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.time.Duration;
import java.time.Instant;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ejb.RemoveListener;
import org.wildfly.clustering.ejb.infinispan.BeanEntry;
import org.wildfly.clustering.ejb.infinispan.BeanExpirationScheduler;
import org.wildfly.clustering.ejb.infinispan.BeanFactory;
import org.wildfly.clustering.ejb.infinispan.BeanRemover;
import org.wildfly.clustering.ejb.infinispan.ExpirationConfiguration;
import org.wildfly.clustering.group.Group;

public class BeanExpirationSchedulerTestCase {
    @Test
    public void testImmortal() throws InterruptedException {
        Group group = (Group)Mockito.mock(Group.class);
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        BeanFactory factory = (BeanFactory)Mockito.mock(BeanFactory.class);
        ExpirationConfiguration config = (ExpirationConfiguration)Mockito.mock(ExpirationConfiguration.class);
        RemoveListener listener = (RemoveListener)Mockito.mock(RemoveListener.class);
        BeanEntry entry = (BeanEntry)Mockito.mock(BeanEntry.class);
        BeanRemover remover = (BeanRemover)Mockito.mock(BeanRemover.class);
        String beanId = "immortal";
        Mockito.when((Object)group.isSingleton()).thenReturn((Object)true);
        Mockito.when((Object)config.getTimeout()).thenReturn((Object)Duration.ofMinutes(-1L));
        Mockito.when((Object)config.getRemoveListener()).thenReturn((Object)listener);
        Mockito.when((Object)entry.getLastAccessedTime()).thenReturn((Object)Instant.now());
        try (BeanExpirationScheduler scheduler = new BeanExpirationScheduler(group, batcher, factory, config, remover, Duration.ZERO);){
            scheduler.schedule((Object)beanId, (Object)entry);
            Thread.sleep(500L);
        }
        ((Batcher)Mockito.verify((Object)batcher, (VerificationMode)Mockito.never())).createBatch();
        ((BeanRemover)Mockito.verify((Object)remover, (VerificationMode)Mockito.never())).remove((Object)beanId, listener);
    }

    @Test
    public void testExpire() throws InterruptedException {
        Group group = (Group)Mockito.mock(Group.class);
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        TransactionBatch batch = (TransactionBatch)Mockito.mock(TransactionBatch.class);
        BeanFactory factory = (BeanFactory)Mockito.mock(BeanFactory.class);
        ExpirationConfiguration config = (ExpirationConfiguration)Mockito.mock(ExpirationConfiguration.class);
        RemoveListener listener = (RemoveListener)Mockito.mock(RemoveListener.class);
        BeanEntry entry = (BeanEntry)Mockito.mock(BeanEntry.class);
        BeanRemover remover = (BeanRemover)Mockito.mock(BeanRemover.class);
        String beanId = "expiring";
        Duration timeout = Duration.ofMillis(10L);
        Mockito.when((Object)group.isSingleton()).thenReturn((Object)true);
        Mockito.when((Object)((TransactionBatch)batcher.createBatch())).thenReturn((Object)batch);
        Mockito.when((Object)config.getTimeout()).thenReturn((Object)timeout);
        Mockito.when((Object)config.getRemoveListener()).thenReturn((Object)listener);
        Mockito.when((Object)entry.getLastAccessedTime()).thenReturn((Object)Instant.now());
        Mockito.when((Object)remover.remove((Object)beanId, listener)).thenReturn((Object)true);
        try (BeanExpirationScheduler scheduler = new BeanExpirationScheduler(group, batcher, factory, config, remover, Duration.ZERO);){
            scheduler.schedule((Object)beanId, (Object)entry);
            Thread.sleep(500L);
        }
        ((TransactionBatch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void testNotYetExpired() throws InterruptedException {
        Group group = (Group)Mockito.mock(Group.class);
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        TransactionBatch batch = (TransactionBatch)Mockito.mock(TransactionBatch.class);
        BeanFactory factory = (BeanFactory)Mockito.mock(BeanFactory.class);
        ExpirationConfiguration config = (ExpirationConfiguration)Mockito.mock(ExpirationConfiguration.class);
        RemoveListener listener = (RemoveListener)Mockito.mock(RemoveListener.class);
        BeanEntry entry = (BeanEntry)Mockito.mock(BeanEntry.class);
        BeanRemover remover = (BeanRemover)Mockito.mock(BeanRemover.class);
        String beanId = "not-expired";
        Duration timeout = Duration.ofMillis(10L);
        Mockito.when((Object)((TransactionBatch)batcher.createBatch())).thenReturn((Object)batch);
        Mockito.when((Object)config.getTimeout()).thenReturn((Object)Duration.ofMillis(1L));
        Mockito.when((Object)config.getRemoveListener()).thenReturn((Object)listener);
        Mockito.when((Object)entry.getLastAccessedTime()).thenReturn((Object)Instant.now().plus(Duration.ofMinutes(1L)));
        Mockito.when((Object)((BeanEntry)factory.findValue((Object)beanId))).thenReturn((Object)entry);
        Mockito.when((Object)entry.isExpired((Duration)Mockito.same((Object)timeout))).thenReturn((Object)false);
        try (BeanExpirationScheduler scheduler = new BeanExpirationScheduler(group, batcher, factory, config, remover, Duration.ZERO);){
            scheduler.schedule((Object)beanId, (Object)entry);
            Thread.sleep(500L);
        }
        ((BeanRemover)Mockito.verify((Object)remover, (VerificationMode)Mockito.never())).remove((Object)beanId, listener);
        ((TransactionBatch)Mockito.verify((Object)batch, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void testCancel() throws InterruptedException {
        Group group = (Group)Mockito.mock(Group.class);
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        BeanFactory factory = (BeanFactory)Mockito.mock(BeanFactory.class);
        ExpirationConfiguration config = (ExpirationConfiguration)Mockito.mock(ExpirationConfiguration.class);
        RemoveListener listener = (RemoveListener)Mockito.mock(RemoveListener.class);
        BeanEntry entry = (BeanEntry)Mockito.mock(BeanEntry.class);
        BeanRemover remover = (BeanRemover)Mockito.mock(BeanRemover.class);
        String beanId = "canceled";
        Duration timeout = Duration.ofMinutes(1L);
        Mockito.when((Object)config.getTimeout()).thenReturn((Object)timeout);
        Mockito.when((Object)config.getRemoveListener()).thenReturn((Object)listener);
        Mockito.when((Object)entry.getLastAccessedTime()).thenReturn((Object)Instant.now());
        try (BeanExpirationScheduler scheduler = new BeanExpirationScheduler(group, batcher, factory, config, remover, Duration.ZERO);){
            scheduler.schedule((Object)beanId, (Object)entry);
            Thread.sleep(500L);
            scheduler.cancel((Object)beanId);
        }
        ((BeanRemover)Mockito.verify((Object)remover, (VerificationMode)Mockito.never())).remove((Object)beanId, listener);
        ((Batcher)Mockito.verify((Object)batcher, (VerificationMode)Mockito.never())).createBatch();
    }
}

