/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.time.Duration;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.ejb.RemoveListener;
import org.wildfly.clustering.ejb.infinispan.BeanEntry;
import org.wildfly.clustering.ejb.infinispan.BeanFactory;
import org.wildfly.clustering.ejb.infinispan.BeanRemover;
import org.wildfly.clustering.ejb.infinispan.ExpirationConfiguration;
import org.wildfly.clustering.ejb.infinispan.ExpiredBeanRemover;

public class ExpiredBeanRemoverTestCase {
    private final BeanFactory<String, Object> factory = (BeanFactory)Mockito.mock(BeanFactory.class);
    private final ExpirationConfiguration<Object> expiration = (ExpirationConfiguration)Mockito.mock(ExpirationConfiguration.class);
    private final BeanRemover<String, Object> remover = new ExpiredBeanRemover(this.factory, this.expiration);

    @Test
    public void locked() {
        RemoveListener listener = (RemoveListener)Mockito.mock(RemoveListener.class);
        String id = "locked";
        Mockito.when((Object)((BeanEntry)this.factory.tryValue((Object)id))).thenReturn(null);
        boolean result = this.remover.remove((Object)id, listener);
        Assert.assertTrue((boolean)result);
        ((BeanFactory)Mockito.verify(this.factory, (VerificationMode)Mockito.never())).remove((Object)id, listener);
    }

    @Test
    public void notExpired() {
        RemoveListener listener = (RemoveListener)Mockito.mock(RemoveListener.class);
        BeanEntry entry = (BeanEntry)Mockito.mock(BeanEntry.class);
        Duration timeout = Duration.ZERO;
        String id = "not-expired";
        Mockito.when((Object)((BeanEntry)this.factory.tryValue((Object)id))).thenReturn((Object)entry);
        Mockito.when((Object)this.expiration.getTimeout()).thenReturn((Object)timeout);
        Mockito.when((Object)entry.isExpired(timeout)).thenReturn((Object)false);
        boolean result = this.remover.remove((Object)id, listener);
        Assert.assertFalse((boolean)result);
        ((BeanFactory)Mockito.verify(this.factory, (VerificationMode)Mockito.never())).remove((Object)id, listener);
    }

    @Test
    public void expired() {
        RemoveListener listener = (RemoveListener)Mockito.mock(RemoveListener.class);
        BeanEntry entry = (BeanEntry)Mockito.mock(BeanEntry.class);
        Duration timeout = Duration.ZERO;
        String id = "expired";
        Mockito.when((Object)((BeanEntry)this.factory.tryValue((Object)id))).thenReturn((Object)entry);
        Mockito.when((Object)this.expiration.getTimeout()).thenReturn((Object)timeout);
        Mockito.when((Object)entry.isExpired(timeout)).thenReturn((Object)true);
        Mockito.when((Object)this.factory.remove((Object)id, listener)).thenReturn((Object)true);
        boolean result = this.remover.remove((Object)id, listener);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void failedToExpired() {
        RemoveListener listener = (RemoveListener)Mockito.mock(RemoveListener.class);
        BeanEntry entry = (BeanEntry)Mockito.mock(BeanEntry.class);
        Duration timeout = Duration.ZERO;
        String id = "not-expired";
        Mockito.when((Object)((BeanEntry)this.factory.tryValue((Object)id))).thenReturn((Object)entry);
        Mockito.when((Object)this.expiration.getTimeout()).thenReturn((Object)timeout);
        Mockito.when((Object)entry.isExpired(timeout)).thenReturn((Object)true);
        Mockito.when((Object)this.factory.remove((Object)id, listener)).thenReturn((Object)false);
        boolean result = this.remover.remove((Object)id, listener);
        Assert.assertFalse((boolean)result);
    }
}

