/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.group;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.Remover;
import org.wildfly.clustering.ejb.PassivationListener;
import org.wildfly.clustering.ejb.infinispan.BeanGroup;
import org.wildfly.clustering.ejb.infinispan.BeanGroupEntry;
import org.wildfly.clustering.ejb.infinispan.group.InfinispanBeanGroup;
import org.wildfly.clustering.marshalling.spi.MarshalledValue;

public class InfinispanBeanGroupTestCase {
    private String id;
    private BeanGroupEntry<String, Object, Object> entry = (BeanGroupEntry)Mockito.mock(BeanGroupEntry.class);
    private Object context = new Object();
    private Mutator mutator = (Mutator)Mockito.mock(Mutator.class);
    private Remover<String> remover = (Remover)Mockito.mock(Remover.class);
    private BeanGroup<String, Object> group = new InfinispanBeanGroup((Object)this.id, this.entry, this.context, this.mutator, this.remover);

    @Test
    public void getId() {
        Assert.assertSame((Object)this.id, (Object)this.group.getId());
    }

    @Test
    public void isCloseable() {
        Mockito.when((Object)this.entry.totalUsage()).thenReturn((Object)1);
        Assert.assertFalse((boolean)this.group.isCloseable());
        Mockito.when((Object)this.entry.totalUsage()).thenReturn((Object)0);
        Assert.assertTrue((boolean)this.group.isCloseable());
    }

    @Test
    public void getBeans() throws IOException {
        MarshalledValue value = (MarshalledValue)Mockito.mock(MarshalledValue.class);
        Map<String, Object> beans = Collections.singletonMap("id", new Object());
        Mockito.when((Object)this.entry.getBeans()).thenReturn((Object)value);
        Mockito.when((Object)((Map)value.get(this.context))).thenReturn(beans);
        Assert.assertSame(beans.keySet(), (Object)this.group.getBeans());
    }

    @Test
    public void addBean() throws IOException {
        MarshalledValue value = (MarshalledValue)Mockito.mock(MarshalledValue.class);
        Map beans = (Map)Mockito.mock(Map.class);
        String id = "id";
        Object bean = new Object();
        Mockito.when((Object)this.entry.getBeans()).thenReturn((Object)value);
        Mockito.when((Object)((Map)value.get(this.context))).thenReturn((Object)beans);
        this.group.addBean((Object)id, bean);
        ((Map)Mockito.verify((Object)beans)).put(id, bean);
    }

    @Test
    public void getBean() throws IOException {
        PassivationListener listener = (PassivationListener)Mockito.mock(PassivationListener.class);
        MarshalledValue value = (MarshalledValue)Mockito.mock(MarshalledValue.class);
        Map beans = (Map)Mockito.mock(Map.class);
        String id = "id";
        Object bean = new Object();
        Mockito.when((Object)this.entry.getBeans()).thenReturn((Object)value);
        Mockito.when((Object)((Map)value.get(this.context))).thenReturn((Object)beans);
        Mockito.when(beans.get(id)).thenReturn(bean);
        Mockito.when((Object)this.entry.incrementUsage((Object)id)).thenReturn((Object)1);
        Object result = this.group.getBean((Object)id, listener);
        Assert.assertSame((Object)bean, (Object)result);
        Mockito.verifyNoInteractions((Object[])new Object[]{listener});
        Mockito.when((Object)this.entry.incrementUsage((Object)id)).thenReturn((Object)0);
        result = this.group.getBean((Object)id, listener);
        Assert.assertSame((Object)bean, (Object)result);
        ((PassivationListener)Mockito.verify((Object)listener)).postActivate(bean);
    }

    @Test
    public void releaseBean() throws IOException {
        PassivationListener listener = (PassivationListener)Mockito.mock(PassivationListener.class);
        MarshalledValue value = (MarshalledValue)Mockito.mock(MarshalledValue.class);
        Map beans = (Map)Mockito.mock(Map.class);
        String id = "id";
        Object bean = new Object();
        Mockito.when((Object)this.entry.decrementUsage((Object)id)).thenReturn((Object)1);
        boolean result = this.group.releaseBean((Object)id, listener);
        Assert.assertFalse((boolean)result);
        Mockito.verifyNoInteractions((Object[])new Object[]{listener});
        ((BeanGroupEntry)Mockito.verify(this.entry, (VerificationMode)Mockito.never())).getBeans();
        Mockito.when((Object)this.entry.decrementUsage((Object)id)).thenReturn((Object)0);
        Mockito.when((Object)this.entry.getBeans()).thenReturn((Object)value);
        Mockito.when((Object)((Map)value.get(this.context))).thenReturn((Object)beans);
        Mockito.when(beans.get(id)).thenReturn(bean);
        result = this.group.releaseBean((Object)id, listener);
        Assert.assertTrue((boolean)result);
        ((PassivationListener)Mockito.verify((Object)listener)).prePassivate(bean);
    }

    @Test
    public void removeBean() throws IOException {
        MarshalledValue value = (MarshalledValue)Mockito.mock(MarshalledValue.class);
        PassivationListener listener = (PassivationListener)Mockito.mock(PassivationListener.class);
        Map beans = (Map)Mockito.mock(Map.class);
        String id = "id";
        Object bean = new Object();
        Mockito.when((Object)this.entry.getBeans()).thenReturn((Object)value);
        Mockito.when((Object)((Map)value.get(this.context))).thenReturn((Object)beans);
        Mockito.when(beans.remove(id)).thenReturn(bean);
        Object result = this.group.removeBean((Object)id, listener);
        Assert.assertSame((Object)bean, (Object)result);
        ((PassivationListener)Mockito.verify((Object)listener)).postActivate(bean);
    }

    @Test
    public void prePassivate() throws IOException {
        PassivationListener listener = (PassivationListener)Mockito.mock(PassivationListener.class);
        MarshalledValue value = (MarshalledValue)Mockito.mock(MarshalledValue.class);
        Map beans = (Map)Mockito.mock(Map.class);
        String id = "id";
        Object bean = new Object();
        this.group.prePassivate((Object)id, null);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.entry});
        Mockito.when((Object)this.entry.getBeans()).thenReturn((Object)value);
        Mockito.when((Object)((Map)value.get(this.context))).thenReturn((Object)beans);
        Mockito.when(beans.get(id)).thenReturn(bean);
        this.group.prePassivate((Object)id, listener);
        ((PassivationListener)Mockito.verify((Object)listener)).prePassivate(bean);
    }

    @Test
    public void postActivate() throws IOException {
        PassivationListener listener = (PassivationListener)Mockito.mock(PassivationListener.class);
        MarshalledValue value = (MarshalledValue)Mockito.mock(MarshalledValue.class);
        Map beans = (Map)Mockito.mock(Map.class);
        String id = "id";
        Object bean = new Object();
        this.group.postActivate((Object)id, null);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.entry});
        Mockito.when((Object)this.entry.getBeans()).thenReturn((Object)value);
        Mockito.when((Object)((Map)value.get(this.context))).thenReturn((Object)beans);
        Mockito.when(beans.get(id)).thenReturn(bean);
        this.group.postActivate((Object)id, listener);
        ((PassivationListener)Mockito.verify((Object)listener)).postActivate(bean);
    }

    @Test
    public void close() throws IOException {
        MarshalledValue value = (MarshalledValue)Mockito.mock(MarshalledValue.class);
        Mockito.when((Object)this.entry.getBeans()).thenReturn((Object)value);
        Mockito.when((Object)((Map)value.get(this.context))).thenReturn(Collections.emptyMap());
        this.group.close();
        ((Remover)Mockito.verify(this.remover)).remove((Object)this.id);
        ((Mutator)Mockito.verify((Object)this.mutator, (VerificationMode)Mockito.never())).mutate();
        Mockito.reset((Object[])new Object[]{this.remover, this.mutator});
        Mockito.when((Object)((Map)value.get(this.context))).thenReturn(Collections.singletonMap("id", new Object()));
        this.group.close();
        ((Mutator)Mockito.verify((Object)this.mutator)).mutate();
        ((Remover)Mockito.verify(this.remover, (VerificationMode)Mockito.never())).remove((Object)this.id);
    }
}

