/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.bean;

import java.util.Map;
import org.infinispan.Cache;
import org.wildfly.clustering.ee.Creator;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.MutatorFactory;
import org.wildfly.clustering.ee.Remover;
import org.wildfly.clustering.ee.infinispan.InfinispanConfiguration;
import org.wildfly.clustering.ee.infinispan.InfinispanMutatorFactory;
import org.wildfly.clustering.ejb.bean.BeanInstance;
import org.wildfly.clustering.ejb.cache.bean.BeanGroupKey;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanGroupKey;
import org.wildfly.clustering.marshalling.spi.MarshalledValue;

public class InfinispanBeanGroupManager<K, V extends BeanInstance<K>, C>
implements Creator<K, MarshalledValue<Map<K, V>, C>, MarshalledValue<Map<K, V>, C>>,
Remover<K>,
MutatorFactory<K, MarshalledValue<Map<K, V>, C>> {
    private final Cache<BeanGroupKey<K>, MarshalledValue<Map<K, V>, C>> cache;
    private final Cache<BeanGroupKey<K>, MarshalledValue<Map<K, V>, C>> removeCache;
    private final MutatorFactory<BeanGroupKey<K>, MarshalledValue<Map<K, V>, C>> mutatorFactory;

    public InfinispanBeanGroupManager(InfinispanConfiguration configuration) {
        this.cache = configuration.getCache();
        this.removeCache = configuration.getWriteOnlyCache();
        this.mutatorFactory = new InfinispanMutatorFactory(configuration.getCache());
    }

    public MarshalledValue<Map<K, V>, C> createValue(K id, MarshalledValue<Map<K, V>, C> defaultValue) {
        MarshalledValue<Map<K, V>, C> value = (MarshalledValue<Map<K, V>, C>)this.cache.putIfAbsent(new InfinispanBeanGroupKey<K>(id), defaultValue);
        return value != null ? value : defaultValue;
    }

    public boolean remove(K id) {
        this.removeCache.remove(new InfinispanBeanGroupKey<K>(id));
        return true;
    }

    public Mutator createMutator(K id, MarshalledValue<Map<K, V>, C> value) {
        return this.mutatorFactory.createMutator(new InfinispanBeanGroupKey<K>(id), value);
    }
}

