/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.timer;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.ejb.infinispan.timer.ImmutableScheduleExpressionBuilder;
import org.wildfly.clustering.ejb.infinispan.timer.ScheduleTimerCreationMetaDataEntry;
import org.wildfly.clustering.ejb.timer.ImmutableScheduleExpression;
import org.wildfly.clustering.ejb.timer.ScheduleTimerConfiguration;
import org.wildfly.clustering.marshalling.MarshallingTester;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamTesterFactory;
import org.wildfly.clustering.marshalling.protostream.TestProtoStreamByteBufferMarshaller;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshalledValue;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshalledValueFactory;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;

public class ScheduleTimerCreationMetaDataEntryMarshallerTestCase {
    @Test
    public void test() throws IOException, NoSuchMethodException {
        ByteBufferMarshalledValue context = new ByteBufferMarshalledValueFactory((ByteBufferMarshaller)TestProtoStreamByteBufferMarshaller.INSTANCE).createMarshalledValue((Object)UUID.randomUUID());
        MarshallingTester tester = ProtoStreamTesterFactory.INSTANCE.createTester();
        tester.test((Object)new ScheduleTimerCreationMetaDataEntry((Object)context, new ScheduleTimerConfiguration(){

            public ImmutableScheduleExpression getScheduleExpression() {
                return new ImmutableScheduleExpressionBuilder().build();
            }
        }, null), ScheduleTimerCreationMetaDataEntryMarshallerTestCase::assertEquals);
        tester.test((Object)new ScheduleTimerCreationMetaDataEntry((Object)context, new ScheduleTimerConfiguration(){

            public ImmutableScheduleExpression getScheduleExpression() {
                return new ImmutableScheduleExpressionBuilder().start(Instant.now()).end(Instant.now().plus(Duration.ofHours(1L))).year("1970").month("1").dayOfMonth("1").dayOfWeek("1").zone(ZoneId.of("GMT")).hour("0").minute("0").second("0").build();
            }
        }, ScheduleTimerCreationMetaDataEntryMarshallerTestCase.class.getDeclaredMethod("test", new Class[0])), ScheduleTimerCreationMetaDataEntryMarshallerTestCase::assertEquals);
        tester.test((Object)new ScheduleTimerCreationMetaDataEntry((Object)context, new ScheduleTimerConfiguration(){

            public ImmutableScheduleExpression getScheduleExpression() {
                return new ImmutableScheduleExpressionBuilder().start(Instant.now()).end(Instant.now().plus(Duration.ofHours(1L))).year("1970").month("JAN").dayOfMonth("1").dayOfWeek("TUES").zone(ZoneId.of("America/New_York")).hour("0").minute("0").second("0").build();
            }
        }, ScheduleTimerCreationMetaDataEntryMarshallerTestCase.class.getDeclaredMethod("ejbTimeout", Object.class)), ScheduleTimerCreationMetaDataEntryMarshallerTestCase::assertEquals);
    }

    void ejbTimeout(Object timer) {
    }

    private static <V> void assertEquals(ScheduleTimerCreationMetaDataEntry<V> entry1, ScheduleTimerCreationMetaDataEntry<V> entry2) {
        Assert.assertEquals((Object)entry1.getContext(), (Object)entry2.getContext());
        Assert.assertEquals((Object)entry1.getStart(), (Object)entry2.getStart());
        Assert.assertEquals((Object)entry1.getTimeoutMatcher(), (Object)entry2.getTimeoutMatcher());
        Assert.assertSame((Object)entry1.getType(), (Object)entry2.getType());
        Assert.assertEquals((Object)entry1.getScheduleExpression().getStart(), (Object)entry2.getScheduleExpression().getStart());
        Assert.assertEquals((Object)entry1.getScheduleExpression().getEnd(), (Object)entry2.getScheduleExpression().getEnd());
        Assert.assertEquals((Object)entry1.getScheduleExpression().getYear(), (Object)entry2.getScheduleExpression().getYear());
        Assert.assertEquals((Object)entry1.getScheduleExpression().getMonth(), (Object)entry2.getScheduleExpression().getMonth());
        Assert.assertEquals((Object)entry1.getScheduleExpression().getDayOfMonth(), (Object)entry2.getScheduleExpression().getDayOfMonth());
        Assert.assertEquals((Object)entry1.getScheduleExpression().getDayOfWeek(), (Object)entry2.getScheduleExpression().getDayOfWeek());
        Assert.assertEquals((Object)entry1.getScheduleExpression().getZone(), (Object)entry2.getScheduleExpression().getZone());
        Assert.assertEquals((Object)entry1.getScheduleExpression().getHour(), (Object)entry2.getScheduleExpression().getHour());
        Assert.assertEquals((Object)entry1.getScheduleExpression().getMinute(), (Object)entry2.getScheduleExpression().getMinute());
        Assert.assertEquals((Object)entry1.getScheduleExpression().getSecond(), (Object)entry2.getScheduleExpression().getSecond());
    }
}

