/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.bean;

import java.util.function.Consumer;
import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.ejb.DeploymentConfiguration;
import org.wildfly.clustering.ejb.bean.BeanConfiguration;
import org.wildfly.clustering.ejb.bean.BeanInstance;
import org.wildfly.clustering.ejb.bean.BeanPassivationConfiguration;
import org.wildfly.clustering.ejb.cache.bean.BeanGroupManager;
import org.wildfly.clustering.ejb.cache.bean.BeanGroupManagerServiceNameProvider;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanManagementConfiguration;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanManagerFactory;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanManagerFactoryConfiguration;
import org.wildfly.clustering.infinispan.affinity.KeyAffinityServiceFactory;
import org.wildfly.clustering.infinispan.service.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.service.InfinispanRequirement;
import org.wildfly.clustering.server.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.server.group.Group;
import org.wildfly.clustering.server.service.ClusteringCacheRequirement;
import org.wildfly.clustering.server.service.ClusteringRequirement;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;

public class InfinispanBeanManagerFactoryServiceConfigurator<K, V extends BeanInstance<K>>
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
InfinispanBeanManagerFactoryConfiguration<K, V> {
    private final String cacheName;
    private final BeanConfiguration beanConfiguration;
    private final InfinispanBeanManagementConfiguration configuration;
    private final SupplierDependency<BeanGroupManager<K, V>> groupManager;
    private volatile SupplierDependency<Cache<?, ?>> cache;
    private volatile SupplierDependency<KeyAffinityServiceFactory> affinityFactory;
    private volatile SupplierDependency<Group<Address>> group;
    private volatile SupplierDependency<CommandDispatcherFactory> dispatcherFactory;

    public InfinispanBeanManagerFactoryServiceConfigurator(BeanConfiguration beanConfiguration, InfinispanBeanManagementConfiguration configuration) {
        super(beanConfiguration.getDeploymentServiceName().append(new String[]{beanConfiguration.getName()}).append(new String[]{"bean-manager"}));
        this.beanConfiguration = beanConfiguration;
        this.configuration = configuration;
        this.cacheName = beanConfiguration.getDeploymentName();
        this.groupManager = new ServiceSupplierDependency((ServiceNameProvider)new BeanGroupManagerServiceNameProvider((DeploymentConfiguration)beanConfiguration));
    }

    public ServiceConfigurator configure(CapabilityServiceSupport support) {
        String containerName = this.configuration.getContainerName();
        this.cache = new ServiceSupplierDependency(InfinispanCacheRequirement.CACHE.getServiceName(support, containerName, this.cacheName));
        this.affinityFactory = new ServiceSupplierDependency(InfinispanRequirement.KEY_AFFINITY_FACTORY.getServiceName(support, containerName));
        this.dispatcherFactory = new ServiceSupplierDependency(ClusteringRequirement.COMMAND_DISPATCHER_FACTORY.getServiceName(support, containerName));
        this.group = new ServiceSupplierDependency(ClusteringCacheRequirement.GROUP.getServiceName(support, containerName, this.cacheName));
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        new CompositeDependency(new Dependency[]{this.cache, this.affinityFactory, this.group, this.dispatcherFactory, this.groupManager}).register(builder);
        Consumer factory = builder.provides(new ServiceName[]{this.getServiceName()});
        Service service = Service.newInstance((Consumer)factory, new InfinispanBeanManagerFactory(this));
        return builder.setInstance(service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public BeanConfiguration getBeanConfiguration() {
        return this.beanConfiguration;
    }

    public <KK, VV> Cache<KK, VV> getCache() {
        return (Cache)this.cache.get();
    }

    @Override
    public KeyAffinityServiceFactory getKeyAffinityServiceFactory() {
        return (KeyAffinityServiceFactory)this.affinityFactory.get();
    }

    public BeanPassivationConfiguration getPassivationConfiguration() {
        return this.configuration;
    }

    @Override
    public Group<Address> getGroup() {
        return (Group)this.group.get();
    }

    @Override
    public CommandDispatcherFactory getCommandDispatcherFactory() {
        return (CommandDispatcherFactory)this.dispatcherFactory.get();
    }

    public BeanGroupManager<K, V> getBeanGroupManager() {
        return (BeanGroupManager)this.groupManager.get();
    }
}

