/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.bean;

import java.time.Duration;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Scheduler;
import org.wildfly.clustering.ee.cache.scheduler.LinkedScheduledEntries;
import org.wildfly.clustering.ee.cache.scheduler.LocalScheduler;
import org.wildfly.clustering.ee.cache.scheduler.ScheduledEntries;
import org.wildfly.clustering.ee.cache.scheduler.SortedScheduledEntries;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ee.infinispan.expiration.AbstractExpirationScheduler;
import org.wildfly.clustering.ejb.bean.BeanExpirationConfiguration;
import org.wildfly.clustering.ejb.bean.BeanInstance;
import org.wildfly.clustering.ejb.bean.ImmutableBeanMetaData;
import org.wildfly.clustering.ejb.cache.bean.BeanFactory;
import org.wildfly.clustering.ejb.cache.bean.ImmutableBeanMetaDataFactory;
import org.wildfly.clustering.ejb.cache.bean.MutableBean;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;
import org.wildfly.clustering.group.Group;

public class BeanExpirationScheduler<K, V extends BeanInstance<K>, M>
extends AbstractExpirationScheduler<K> {
    private final ImmutableBeanMetaDataFactory<K, M> factory;

    public BeanExpirationScheduler(Group group, Batcher<TransactionBatch> batcher, BeanFactory<K, V, M> factory, BeanExpirationConfiguration<K, V> expiration, Duration closeTimeout) {
        super((Scheduler)new LocalScheduler((ScheduledEntries)(group.isSingleton() ? new LinkedScheduledEntries() : new SortedScheduledEntries()), new BeanRemoveTask<K, V, M>(batcher, factory, expiration.getExpirationListener()), closeTimeout));
        this.factory = factory.getMetaDataFactory();
    }

    public void schedule(K id) {
        Object value = this.factory.findValue(id);
        if (value != null) {
            ImmutableBeanMetaData metaData = this.factory.createImmutableBeanMetaData(id, value);
            this.schedule(id, metaData);
        }
    }

    private static class BeanRemoveTask<K, V extends BeanInstance<K>, M>
    implements Predicate<K> {
        private final Batcher<TransactionBatch> batcher;
        private final BeanFactory<K, V, M> factory;
        private final Consumer<V> timeoutListener;

        BeanRemoveTask(Batcher<TransactionBatch> batcher, BeanFactory<K, V, M> factory, Consumer<V> timeoutListener) {
            this.batcher = batcher;
            this.timeoutListener = timeoutListener;
            this.factory = factory;
        }

        @Override
        public boolean test(K id) {
            boolean bl;
            block19: {
                InfinispanEjbLogger.ROOT_LOGGER.tracef("Expiring stateful session bean %s", id);
                Batch batch = this.batcher.createBatch();
                try {
                    Object value = this.factory.tryValue(id);
                    if (value != null) {
                        try (MutableBean bean = this.factory.createBean(id, value);){
                            if (bean.getMetaData().isExpired()) {
                                bean.remove(this.timeoutListener);
                            }
                        }
                    }
                    bl = true;
                    if (batch == null) break block19;
                }
                catch (RuntimeException e) {
                    try {
                        try {
                            batch.discard();
                            throw e;
                        }
                        catch (Throwable throwable) {
                            if (batch != null) {
                                try {
                                    batch.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                    catch (RuntimeException e2) {
                        InfinispanEjbLogger.ROOT_LOGGER.failedToExpireBean(e2, id);
                        return false;
                    }
                }
                batch.close();
            }
            return bl;
        }
    }
}

