/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.bean;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.context.DefaultThreadFactory;
import org.wildfly.clustering.ejb.bean.BeanExpirationConfiguration;
import org.wildfly.clustering.ejb.bean.BeanInstance;
import org.wildfly.clustering.ejb.bean.ImmutableBeanMetaData;
import org.wildfly.clustering.ejb.cache.bean.BeanFactory;
import org.wildfly.clustering.ejb.cache.bean.ImmutableBeanMetaDataFactory;
import org.wildfly.clustering.ejb.cache.bean.MutableBean;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;
import org.wildfly.clustering.server.infinispan.CacheContainerGroup;
import org.wildfly.clustering.server.infinispan.expiration.AbstractExpirationScheduler;
import org.wildfly.clustering.server.local.scheduler.LocalScheduler;
import org.wildfly.clustering.server.local.scheduler.LocalSchedulerConfiguration;
import org.wildfly.clustering.server.local.scheduler.ScheduledEntries;
import org.wildfly.clustering.server.scheduler.Scheduler;
import org.wildfly.security.manager.WildFlySecurityManager;

public class BeanExpirationScheduler<K, V extends BeanInstance<K>, M>
extends AbstractExpirationScheduler<K> {
    private static final ThreadFactory THREAD_FACTORY = new DefaultThreadFactory(BeanExpirationScheduler.class, WildFlySecurityManager.getClassLoaderPrivileged(BeanExpirationScheduler.class));
    private final ImmutableBeanMetaDataFactory<K, M> factory;

    public BeanExpirationScheduler(final String name, final CacheContainerGroup group, final Supplier<Batch> batchFactory, final BeanFactory<K, V, M> factory, final BeanExpirationConfiguration<K, V> expiration, final Duration closeTimeout) {
        super((Scheduler)new LocalScheduler(new LocalSchedulerConfiguration<K>(){

            public String getName() {
                return name;
            }

            public ScheduledEntries<K, Instant> getScheduledEntries() {
                return group.isSingleton() ? ScheduledEntries.linked() : ScheduledEntries.sorted();
            }

            public Predicate<K> getTask() {
                return new BeanRemoveTask(batchFactory, factory, expiration.getExpirationListener());
            }

            public ThreadFactory getThreadFactory() {
                return THREAD_FACTORY;
            }

            public Duration getCloseTimeout() {
                return closeTimeout;
            }
        }));
        this.factory = factory.getMetaDataFactory();
    }

    public void schedule(K id) {
        Object value = this.factory.findValue(id);
        if (value != null) {
            ImmutableBeanMetaData metaData = this.factory.createImmutableBeanMetaData(id, value);
            this.schedule(id, metaData);
        }
    }

    private static class BeanRemoveTask<K, V extends BeanInstance<K>, M>
    implements Predicate<K> {
        private final Supplier<Batch> batchFactory;
        private final BeanFactory<K, V, M> factory;
        private final Consumer<V> timeoutListener;

        BeanRemoveTask(Supplier<Batch> batchFactory, BeanFactory<K, V, M> factory, Consumer<V> timeoutListener) {
            this.batchFactory = batchFactory;
            this.timeoutListener = timeoutListener;
            this.factory = factory;
        }

        @Override
        public boolean test(K id) {
            boolean bl;
            block19: {
                InfinispanEjbLogger.ROOT_LOGGER.tracef("Expiring stateful session bean %s", id);
                Batch batch = this.batchFactory.get();
                try {
                    Object value = this.factory.tryValue(id);
                    if (value != null) {
                        try (MutableBean bean = this.factory.createBean(id, value);){
                            if (bean.getMetaData().isExpired()) {
                                bean.remove(this.timeoutListener);
                            }
                        }
                    }
                    bl = true;
                    if (batch == null) break block19;
                }
                catch (RuntimeException e) {
                    try {
                        try {
                            batch.discard();
                            throw e;
                        }
                        catch (Throwable throwable) {
                            if (batch != null) {
                                try {
                                    batch.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                    catch (RuntimeException e2) {
                        InfinispanEjbLogger.ROOT_LOGGER.failedToExpireBean(e2, id);
                        return false;
                    }
                }
                batch.close();
            }
            return bl;
        }
    }
}

