/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.timer;

import io.github.resilience4j.retry.RetryConfig;
import java.io.IOException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.util.function.SerializablePredicate;
import org.wildfly.clustering.cache.CacheProperties;
import org.wildfly.clustering.cache.Key;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.infinispan.embedded.distribution.Locality;
import org.wildfly.clustering.cache.infinispan.embedded.listener.ListenerRegistration;
import org.wildfly.clustering.ejb.cache.timer.IntervalTimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.RemappableTimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.ScheduleTimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.TimerFactory;
import org.wildfly.clustering.ejb.cache.timer.TimerIndex;
import org.wildfly.clustering.ejb.cache.timer.TimerMetaDataFactory;
import org.wildfly.clustering.ejb.infinispan.timer.InfinispanTimerManagerConfiguration;
import org.wildfly.clustering.ejb.infinispan.timer.TimerMetaDataKeyFilter;
import org.wildfly.clustering.ejb.infinispan.timer.TimerScheduler;
import org.wildfly.clustering.ejb.timer.ImmutableTimerMetaData;
import org.wildfly.clustering.ejb.timer.IntervalTimerConfiguration;
import org.wildfly.clustering.ejb.timer.ScheduleTimerConfiguration;
import org.wildfly.clustering.ejb.timer.Timer;
import org.wildfly.clustering.ejb.timer.TimerManager;
import org.wildfly.clustering.ejb.timer.TimerRegistry;
import org.wildfly.clustering.marshalling.Marshaller;
import org.wildfly.clustering.server.infinispan.CacheContainerGroup;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMember;
import org.wildfly.clustering.server.infinispan.affinity.UnaryGroupMemberAffinity;
import org.wildfly.clustering.server.infinispan.dispatcher.CacheContainerCommandDispatcherFactory;
import org.wildfly.clustering.server.infinispan.manager.AffinityIdentifierFactory;
import org.wildfly.clustering.server.infinispan.scheduler.CacheEntryScheduler;
import org.wildfly.clustering.server.infinispan.scheduler.PrimaryOwnerScheduler;
import org.wildfly.clustering.server.infinispan.scheduler.PrimaryOwnerSchedulerConfiguration;
import org.wildfly.clustering.server.infinispan.scheduler.ScheduleCommand;
import org.wildfly.clustering.server.infinispan.scheduler.ScheduleLocalKeysTask;
import org.wildfly.clustering.server.infinispan.scheduler.ScheduleWithPersistentMetaDataCommand;
import org.wildfly.clustering.server.infinispan.scheduler.ScheduleWithTransientMetaDataCommand;
import org.wildfly.clustering.server.infinispan.scheduler.SchedulerTopologyChangeListener;
import org.wildfly.clustering.server.manager.IdentifierFactory;
import org.wildfly.clustering.server.scheduler.Scheduler;

public class InfinispanTimerManager<I, C>
implements TimerManager<I> {
    private final Cache<Key<I>, ?> cache;
    private final CacheProperties properties;
    private final RetryConfig retryConfig;
    private final TimerFactory<I, RemappableTimerMetaDataEntry<C>> factory;
    private final Marshaller<Object, C> marshaller;
    private final IdentifierFactory<I> identifierFactory;
    private final Supplier<Batch> batchFactory;
    private final CacheContainerCommandDispatcherFactory dispatcherFactory;
    private final TimerRegistry<I> registry;
    private volatile Scheduler<I, ImmutableTimerMetaData> scheduledTimers;
    private volatile Scheduler<I, ImmutableTimerMetaData> scheduler;
    private volatile ListenerRegistration schedulerListenerRegistration;

    public InfinispanTimerManager(InfinispanTimerManagerConfiguration<I, C> config) {
        this.cache = config.getCache();
        this.properties = config.getCacheProperties();
        this.retryConfig = config.getRetryConfig();
        this.marshaller = config.getMarshaller();
        this.identifierFactory = new AffinityIdentifierFactory(config.getIdentifierFactory(), this.cache);
        this.batchFactory = config.getBatchFactory();
        this.dispatcherFactory = config.getCommandDispatcherFactory();
        this.factory = config.getTimerFactory();
        this.registry = config.getRegistry();
    }

    public boolean isStarted() {
        return this.identifierFactory.isStarted();
    }

    public void start() {
        Supplier<Locality> locality = () -> Locality.forCurrentConsistentHash(this.cache);
        PrimaryOwnerScheduler localScheduler = new TimerScheduler(this.cache.getName(), this.factory, this, locality, Duration.ofMillis(this.cache.getCacheConfiguration().transaction().cacheStopTimeout()), this.registry);
        this.scheduledTimers = localScheduler;
        CacheContainerGroup group = this.dispatcherFactory.getGroup();
        this.scheduler = group.isSingleton() ? localScheduler : new PrimaryOwnerScheduler(new PrimaryOwnerSchedulerConfiguration<I, ImmutableTimerMetaData>((TimerScheduler)localScheduler, group){
            final /* synthetic */ TimerScheduler val$localScheduler;
            final /* synthetic */ CacheContainerGroup val$group;
            {
                this.val$localScheduler = timerScheduler;
                this.val$group = cacheContainerGroup;
            }

            public String getName() {
                return InfinispanTimerManager.this.cache.getName();
            }

            public CacheContainerCommandDispatcherFactory getCommandDispatcherFactory() {
                return InfinispanTimerManager.this.dispatcherFactory;
            }

            public CacheEntryScheduler<I, ImmutableTimerMetaData> getScheduler() {
                return this.val$localScheduler;
            }

            public Function<I, CacheContainerGroupMember> getAffinity() {
                return new UnaryGroupMemberAffinity(InfinispanTimerManager.this.cache, this.val$group);
            }

            public BiFunction<I, ImmutableTimerMetaData, ScheduleCommand<I, ImmutableTimerMetaData>> getScheduleCommandFactory() {
                return InfinispanTimerManager.this.properties.isTransactional() ? ScheduleWithPersistentMetaDataCommand::new : ScheduleWithTransientMetaDataCommand::new;
            }

            public RetryConfig getRetryConfig() {
                return InfinispanTimerManager.this.retryConfig;
            }
        });
        TimerRegistry<I> registry = this.registry;
        ScheduleLocalKeysTask scheduleTask = new ScheduleLocalKeysTask(this.cache, (Predicate)((Object)TimerMetaDataKeyFilter.INSTANCE), new Consumer<I>(){
            final /* synthetic */ TimerScheduler val$localScheduler;
            final /* synthetic */ TimerRegistry val$registry;
            {
                this.val$localScheduler = timerScheduler;
                this.val$registry = timerRegistry;
            }

            @Override
            public void accept(I id) {
                this.val$localScheduler.schedule(id);
                this.val$registry.register(id);
            }
        });
        this.schedulerListenerRegistration = new SchedulerTopologyChangeListener(this.cache, (CacheEntryScheduler)localScheduler, (BiConsumer)scheduleTask).register();
        scheduleTask.accept(Locality.of((boolean)false), Locality.forCurrentConsistentHash(this.cache));
        this.identifierFactory.start();
    }

    public void stop() {
        Scheduler<I, ImmutableTimerMetaData> scheduler;
        this.identifierFactory.stop();
        ListenerRegistration registration = this.schedulerListenerRegistration;
        if (registration != null) {
            registration.close();
        }
        if ((scheduler = this.scheduler) != null) {
            scheduler.close();
        }
    }

    public Timer<I> createTimer(I id, IntervalTimerConfiguration config, Object context) {
        try {
            IntervalTimerMetaDataEntry entry = new IntervalTimerMetaDataEntry(this.marshaller.write(context), config);
            return this.createTimer(id, (RemappableTimerMetaDataEntry<C>)entry, null);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Timer<I> createTimer(I id, ScheduleTimerConfiguration config, Object context) {
        try {
            ScheduleTimerMetaDataEntry entry = new ScheduleTimerMetaDataEntry(this.marshaller.write(context), config);
            return this.createTimer(id, (RemappableTimerMetaDataEntry<C>)entry, null);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Timer<I> createTimer(I id, ScheduleTimerConfiguration config, Object context, Method method, int index) {
        try {
            ScheduleTimerMetaDataEntry entry = new ScheduleTimerMetaDataEntry(this.marshaller.write(context), config, method);
            return this.createTimer(id, (RemappableTimerMetaDataEntry<C>)entry, new TimerIndex(method, index));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private Timer<I> createTimer(I id, RemappableTimerMetaDataEntry<C> entry, TimerIndex index) {
        TimerMetaDataFactory metaDataFactory = this.factory.getMetaDataFactory();
        if (metaDataFactory.createValue(id, new AbstractMap.SimpleImmutableEntry<RemappableTimerMetaDataEntry<C>, TimerIndex>(entry, index)) == null) {
            return null;
        }
        ImmutableTimerMetaData metaData = metaDataFactory.createImmutableTimerMetaData(entry);
        Timer timer = this.factory.createTimer(id, metaData, (TimerManager)this, this.scheduledTimers);
        return timer;
    }

    public Timer<I> getTimer(I id) {
        TimerMetaDataFactory metaDataFactory = this.factory.getMetaDataFactory();
        RemappableTimerMetaDataEntry entry = (RemappableTimerMetaDataEntry)metaDataFactory.findValue(id);
        if (entry != null) {
            ImmutableTimerMetaData metaData = metaDataFactory.createImmutableTimerMetaData((Object)entry);
            return this.factory.createTimer(id, metaData, (TimerManager)this, this.scheduledTimers);
        }
        return null;
    }

    public Stream<I> getActiveTimers() {
        return this.dispatcherFactory.getGroup().isSingleton() ? this.scheduledTimers.stream() : this.cache.keySet().stream().filter((SerializablePredicate)TimerMetaDataKeyFilter.INSTANCE).map(Key::getId);
    }

    public Supplier<I> getIdentifierFactory() {
        return this.identifierFactory;
    }

    public Supplier<Batch> getBatchFactory() {
        return this.batchFactory;
    }

    public String toString() {
        return this.cache.getName();
    }
}

