/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.network;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jboss.as.network.ClientMapping;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;
import org.wildfly.clustering.marshalling.Tester;
import org.wildfly.clustering.marshalling.TesterFactory;
import org.wildfly.clustering.marshalling.junit.TesterFactorySource;

public class ClientMappingMarshallerTestCase {
    @ParameterizedTest
    @TesterFactorySource(value={MarshallingTesterFactory.class})
    public void test(TesterFactory factory) throws UnknownHostException {
        Tester tester = factory.createTester(ClientMappingMarshallerTestCase::assertEquals);
        tester.accept((Object)new ClientMapping(InetAddress.getByName("0.0.0.0"), 0, InetAddress.getLoopbackAddress().getHostName(), 8080));
        tester.accept((Object)new ClientMapping(InetAddress.getLocalHost(), 16, InetAddress.getLocalHost().getHostName(), Short.MAX_VALUE));
    }

    static void assertEquals(ClientMapping mapping1, ClientMapping mapping2) {
        Assertions.assertEquals((Object)mapping1.getSourceNetworkAddress(), (Object)mapping2.getSourceNetworkAddress());
        Assertions.assertEquals((int)mapping1.getSourceNetworkMaskBits(), (int)mapping2.getSourceNetworkMaskBits());
        Assertions.assertEquals((Object)mapping1.getDestinationAddress(), (Object)mapping2.getDestinationAddress());
        Assertions.assertEquals((int)mapping1.getDestinationPort(), (int)mapping2.getDestinationPort());
    }
}

