/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.timer;

import io.github.resilience4j.retry.RetryConfig;
import java.io.IOException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.util.function.SerializablePredicate;
import org.wildfly.clustering.cache.CacheEntryLocator;
import org.wildfly.clustering.cache.CacheProperties;
import org.wildfly.clustering.cache.Key;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.function.Consumer;
import org.wildfly.clustering.cache.infinispan.embedded.distribution.CacheStreamFilter;
import org.wildfly.clustering.cache.infinispan.embedded.distribution.Locality;
import org.wildfly.clustering.cache.infinispan.embedded.listener.ListenerRegistration;
import org.wildfly.clustering.ejb.cache.timer.ImmutableTimerMetaDataFactory;
import org.wildfly.clustering.ejb.cache.timer.IntervalTimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.RemappableTimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.ScheduleTimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.TimerFactory;
import org.wildfly.clustering.ejb.cache.timer.TimerIndex;
import org.wildfly.clustering.ejb.cache.timer.TimerMetaDataFactory;
import org.wildfly.clustering.ejb.cache.timer.TimerMetaDataKey;
import org.wildfly.clustering.ejb.infinispan.timer.InfinispanTimerManagerConfiguration;
import org.wildfly.clustering.ejb.infinispan.timer.ScheduleWithPersistentTimeoutMetaDataCommand;
import org.wildfly.clustering.ejb.infinispan.timer.TimerCacheEntryFilter;
import org.wildfly.clustering.ejb.infinispan.timer.TimerCacheKeyFilter;
import org.wildfly.clustering.ejb.infinispan.timer.TimerScheduler;
import org.wildfly.clustering.ejb.timer.ImmutableTimerMetaData;
import org.wildfly.clustering.ejb.timer.IntervalTimerConfiguration;
import org.wildfly.clustering.ejb.timer.ScheduleTimerConfiguration;
import org.wildfly.clustering.ejb.timer.TimeoutMetaData;
import org.wildfly.clustering.ejb.timer.Timer;
import org.wildfly.clustering.ejb.timer.TimerManager;
import org.wildfly.clustering.ejb.timer.TimerRegistry;
import org.wildfly.clustering.marshalling.Marshaller;
import org.wildfly.clustering.server.infinispan.CacheContainerGroup;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMember;
import org.wildfly.clustering.server.infinispan.affinity.UnaryGroupMemberAffinity;
import org.wildfly.clustering.server.infinispan.dispatcher.CacheContainerCommandDispatcherFactory;
import org.wildfly.clustering.server.infinispan.manager.AffinityIdentifierFactory;
import org.wildfly.clustering.server.infinispan.scheduler.CacheEntriesTask;
import org.wildfly.clustering.server.infinispan.scheduler.CacheKeysTask;
import org.wildfly.clustering.server.infinispan.scheduler.PrimaryOwnerScheduler;
import org.wildfly.clustering.server.infinispan.scheduler.PrimaryOwnerSchedulerConfiguration;
import org.wildfly.clustering.server.infinispan.scheduler.ScheduleCommand;
import org.wildfly.clustering.server.infinispan.scheduler.ScheduleWithTransientMetaDataCommand;
import org.wildfly.clustering.server.infinispan.scheduler.Scheduler;
import org.wildfly.clustering.server.infinispan.scheduler.SchedulerTopologyChangeListener;
import org.wildfly.clustering.server.manager.IdentifierFactory;

public class InfinispanTimerManager<I, C>
implements TimerManager<I> {
    private final Cache<TimerMetaDataKey<I>, RemappableTimerMetaDataEntry<C>> cache;
    private final TimerFactory<I, RemappableTimerMetaDataEntry<C>> factory;
    private final Marshaller<Object, C> marshaller;
    private final IdentifierFactory<I> identifierFactory;
    private final AtomicBoolean identifierFactoryStarted = new AtomicBoolean(false);
    private final Supplier<Batch> batchFactory;
    private final TimerRegistry<I> registry;
    private final Scheduler<I, TimeoutMetaData> inactiveScheduler = Scheduler.inactive();
    private final Scheduler<I, TimeoutMetaData> scheduler;
    private final AtomicReference<Scheduler<I, TimeoutMetaData>> schedulerReference = new AtomicReference<Scheduler<I, TimeoutMetaData>>(this.inactiveScheduler);
    private final AtomicReference<ListenerRegistration> schedulerListenerRegistration = new AtomicReference();

    public InfinispanTimerManager(final InfinispanTimerManagerConfiguration<I, C> config) {
        this.cache = config.getCache();
        this.marshaller = config.getMarshaller();
        this.identifierFactory = new AffinityIdentifierFactory(config.getIdentifierFactory(), this.cache);
        this.batchFactory = config.getBatchFactory();
        this.factory = config.getTimerFactory();
        this.registry = config.getRegistry();
        final CacheProperties properties = config.getCacheProperties();
        final RetryConfig retryConfig = config.getRetryConfig();
        final CacheContainerCommandDispatcherFactory dispatcherFactory = config.getCommandDispatcherFactory();
        final CacheContainerGroup group = dispatcherFactory.getGroup();
        final Scheduler localScheduler = Scheduler.fromReference(this.schedulerReference::get);
        Object object = this.scheduler = group.isSingleton() ? localScheduler : new PrimaryOwnerScheduler(new PrimaryOwnerSchedulerConfiguration<I, TimeoutMetaData>(){

            public String getName() {
                return config.getCache().getName();
            }

            public CacheContainerCommandDispatcherFactory getCommandDispatcherFactory() {
                return dispatcherFactory;
            }

            public Scheduler<I, TimeoutMetaData> getScheduler() {
                return localScheduler;
            }

            public Function<I, CacheContainerGroupMember> getAffinity() {
                return new UnaryGroupMemberAffinity(config.getCache(), group);
            }

            public BiFunction<I, TimeoutMetaData, ScheduleCommand<I, TimeoutMetaData>> getScheduleCommandFactory() {
                return properties.isTransactional() ? ScheduleWithPersistentTimeoutMetaDataCommand::new : ScheduleWithTransientMetaDataCommand::new;
            }

            public RetryConfig getRetryConfig() {
                return retryConfig;
            }
        });
        if (properties.isActive()) {
            this.identifierFactory.start();
            this.identifierFactoryStarted.set(true);
        }
    }

    public boolean isStarted() {
        return this.identifierFactory.isStarted();
    }

    public void start() {
        Supplier<Locality> locality = () -> Locality.forCurrentConsistentHash(this.cache);
        TimerScheduler<I, RemappableTimerMetaDataEntry<C>> localScheduler = new TimerScheduler<I, RemappableTimerMetaDataEntry<C>>(this.cache.getName(), this.factory, this, locality, Duration.ofMillis(this.cache.getCacheConfiguration().transaction().cacheStopTimeout()), this.registry);
        Scheduler scheduler = (Scheduler)this.schedulerReference.getAndSet((Scheduler<I, TimeoutMetaData>)localScheduler);
        if (scheduler != null) {
            scheduler.close();
        }
        CacheEntriesTask scheduleTask = new CacheEntriesTask(this.cache, TimerCacheEntryFilter.META_DATA_ENTRY.cast(), localScheduler::schedule);
        Consumer cancel = arg_0 -> localScheduler.cancel(arg_0);
        CacheKeysTask cancelTask = new CacheKeysTask(this.cache, (Predicate)((Object)TimerCacheKeyFilter.META_DATA_KEY), (java.util.function.Consumer)cancel.map(Key::getId));
        this.schedulerListenerRegistration.set(new SchedulerTopologyChangeListener(this.cache, (java.util.function.Consumer)scheduleTask, (java.util.function.Consumer)cancelTask).register());
        scheduleTask.accept(CacheStreamFilter.local(this.cache));
        if (this.identifierFactoryStarted.compareAndSet(false, true)) {
            this.identifierFactory.start();
        }
    }

    public void stop() {
        Scheduler<I, TimeoutMetaData> scheduler;
        ListenerRegistration registration;
        if (this.identifierFactoryStarted.compareAndSet(true, false)) {
            this.identifierFactory.stop();
        }
        if ((registration = (ListenerRegistration)this.schedulerListenerRegistration.getAndSet(null)) != null) {
            registration.close();
        }
        if ((scheduler = this.schedulerReference.getAndSet(this.inactiveScheduler)) != null) {
            scheduler.close();
        }
    }

    public void close() {
        this.scheduler.close();
    }

    public Timer<I> createTimer(I id, IntervalTimerConfiguration config, Object context) {
        try {
            IntervalTimerMetaDataEntry entry = new IntervalTimerMetaDataEntry(this.marshaller.write(context), config);
            return this.createTimer(id, (RemappableTimerMetaDataEntry<C>)entry, null);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Timer<I> createTimer(I id, ScheduleTimerConfiguration config, Object context) {
        try {
            ScheduleTimerMetaDataEntry entry = new ScheduleTimerMetaDataEntry(this.marshaller.write(context), config);
            return this.createTimer(id, (RemappableTimerMetaDataEntry<C>)entry, null);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Timer<I> createTimer(I id, ScheduleTimerConfiguration config, Object context, Method method, int index) {
        try {
            ScheduleTimerMetaDataEntry entry = new ScheduleTimerMetaDataEntry(this.marshaller.write(context), config, method);
            return this.createTimer(id, (RemappableTimerMetaDataEntry<C>)entry, new TimerIndex(method, index));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private Timer<I> createTimer(I id, RemappableTimerMetaDataEntry<C> entry, TimerIndex index) {
        TimerMetaDataFactory metaDataFactory = this.factory.getMetaDataFactory();
        if (metaDataFactory.createValue(id, new AbstractMap.SimpleImmutableEntry<RemappableTimerMetaDataEntry<C>, TimerIndex>(entry, index)) == null) {
            return null;
        }
        ImmutableTimerMetaData metaData = metaDataFactory.createImmutableTimerMetaData(entry);
        Timer timer = this.factory.createTimer(id, metaData, (TimerManager)this, this.scheduler);
        return timer;
    }

    public Timer<I> getTimer(I id) {
        return this.findTimer(CacheEntryLocator::findValue, id);
    }

    public Timer<I> readTimer(I id) {
        return this.findTimer(CacheEntryLocator::tryValue, id);
    }

    private Timer<I> findTimer(BiFunction<ImmutableTimerMetaDataFactory<I, RemappableTimerMetaDataEntry<C>>, I, RemappableTimerMetaDataEntry<C>> finder, I id) {
        TimerMetaDataFactory metaDataFactory = this.factory.getMetaDataFactory();
        RemappableTimerMetaDataEntry<C> entry = finder.apply((ImmutableTimerMetaDataFactory<I, RemappableTimerMetaDataEntry<C>>)metaDataFactory, id);
        if (entry != null) {
            ImmutableTimerMetaData metaData = metaDataFactory.createImmutableTimerMetaData(entry);
            return this.factory.createTimer(id, metaData, (TimerManager)this, this.scheduler);
        }
        return null;
    }

    public Stream<I> getActiveTimers() {
        return this.cache.keySet().stream().filter((SerializablePredicate)TimerCacheKeyFilter.META_DATA_KEY).map(Key::getId);
    }

    public Supplier<I> getIdentifierFactory() {
        return this.identifierFactory;
    }

    public Supplier<Batch> getBatchFactory() {
        return this.batchFactory;
    }

    public String toString() {
        return this.cache.getName();
    }
}

