/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.as.clustering.concurrent.Scheduler;
import org.jboss.as.clustering.infinispan.invoker.Evictor;
import org.wildfly.clustering.ejb.Batch;
import org.wildfly.clustering.ejb.Batcher;
import org.wildfly.clustering.ejb.Bean;
import org.wildfly.clustering.ejb.infinispan.InfinispanEjbLogger;
import org.wildfly.clustering.ejb.infinispan.PassivationConfiguration;

public class BeanEvictionScheduler<G, I, T>
implements Scheduler<Bean<G, I, T>> {
    private final Set<I> evictionQueue = new LinkedHashSet<I>();
    final Batcher batcher;
    final Evictor<I> evictor;
    private final PassivationConfiguration<?> config;

    public BeanEvictionScheduler(Batcher batcher, Evictor<I> evictor, PassivationConfiguration<?> config) {
        this.batcher = batcher;
        this.evictor = evictor;
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(Bean<G, I, T> bean) {
        Set<I> set = this.evictionQueue;
        synchronized (set) {
            this.evictionQueue.remove(bean.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Bean<G, I, T> bean) {
        Set<I> set = this.evictionQueue;
        synchronized (set) {
            this.evictionQueue.add(bean.getId());
            if (this.evictionQueue.size() > this.config.getConfiguration().getMaxSize()) {
                Iterator<I> beans = this.evictionQueue.iterator();
                this.config.getExecutor().execute(new EvictionTask(beans.next()));
                beans.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Set<I> set = this.evictionQueue;
        synchronized (set) {
            this.evictionQueue.clear();
        }
    }

    private class EvictionTask
    implements Runnable {
        private final I id;

        EvictionTask(I id) {
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Batch batch = BeanEvictionScheduler.this.batcher.startBatch();
            boolean success = false;
            try {
                InfinispanEjbLogger.ROOT_LOGGER.tracef("Evicting stateful session bean %s", this.id);
                BeanEvictionScheduler.this.evictor.evict(this.id);
                success = true;
            }
            finally {
                if (success) {
                    batch.close();
                } else {
                    batch.discard();
                }
            }
        }
    }
}

