/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.infinispan.affinity.KeyAffinityServiceFactory;
import org.jboss.as.clustering.infinispan.affinity.KeyAffinityServiceFactoryService;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.infinispan.invoker.RetryingCacheInvoker;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.marshalling.MarshalledValueFactory;
import org.jboss.as.clustering.marshalling.MarshallingContext;
import org.jboss.as.clustering.marshalling.SimpleMarshalledValueFactory;
import org.jboss.as.clustering.marshalling.SimpleMarshallingContext;
import org.jboss.as.clustering.marshalling.SimpleMarshallingContextFactory;
import org.jboss.as.clustering.marshalling.VersionedMarshallingConfiguration;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.ejb.BeanContext;
import org.wildfly.clustering.ejb.BeanManager;
import org.wildfly.clustering.ejb.BeanManagerFactory;
import org.wildfly.clustering.ejb.BeanManagerFactoryBuilderConfiguration;
import org.wildfly.clustering.ejb.BeanPassivationConfiguration;
import org.wildfly.clustering.ejb.IdentifierFactory;
import org.wildfly.clustering.ejb.PassivationListener;
import org.wildfly.clustering.ejb.RemoveListener;
import org.wildfly.clustering.ejb.Time;
import org.wildfly.clustering.ejb.infinispan.BeanCacheConfigurationService;
import org.wildfly.clustering.ejb.infinispan.Configuration;
import org.wildfly.clustering.ejb.infinispan.ExpirationConfiguration;
import org.wildfly.clustering.ejb.infinispan.InfinispanBeanManager;
import org.wildfly.clustering.ejb.infinispan.PassivationConfiguration;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanFactory;
import org.wildfly.clustering.ejb.infinispan.group.InfinispanBeanGroupFactory;
import org.wildfly.clustering.group.NodeFactory;
import org.wildfly.clustering.registry.Registry;

public class InfinispanBeanManagerFactory<G, I, T>
extends AbstractService<BeanManagerFactory<G, I, T>>
implements BeanManagerFactory<G, I, T> {
    private final BeanContext context;
    private final CacheInvoker invoker = new RetryingCacheInvoker(new int[]{10, 100});
    private final InjectedValue<Cache> cache = new InjectedValue();
    private final InjectedValue<KeyAffinityServiceFactory> affinityFactory = new InjectedValue();
    private final InjectedValue<VersionedMarshallingConfiguration> config = new InjectedValue();
    private final InjectedValue<ScheduledExecutorService> scheduler = new InjectedValue();
    private final InjectedValue<Executor> executor = new InjectedValue();
    private final BeanPassivationConfiguration passivationConfig;
    private final InjectedValue<NodeFactory> nodeFactory = new InjectedValue();
    private final InjectedValue<Registry> registry = new InjectedValue();

    public static <G, I, T> ServiceBuilder<BeanManagerFactory<G, I, T>> build(String name, ServiceTarget target, ServiceName serviceName, BeanManagerFactoryBuilderConfiguration config, BeanContext context) {
        InfinispanBeanManagerFactory<G, I, T> factory = new InfinispanBeanManagerFactory<G, I, T>(context, (BeanPassivationConfiguration)config);
        String containerName = config.getContainerName();
        ServiceName deploymentUnitServiceName = context.getDeploymentUnitServiceName();
        return target.addService(serviceName, factory).addDependency(CacheService.getServiceName((String)containerName, (String)BeanCacheConfigurationService.getCacheName(context.getDeploymentUnitServiceName())), Cache.class, factory.cache).addDependency(KeyAffinityServiceFactoryService.getServiceName((String)containerName), KeyAffinityServiceFactory.class, factory.affinityFactory).addDependency(deploymentUnitServiceName.append(new String[]{"marshalling"}), VersionedMarshallingConfiguration.class, factory.config).addDependency(deploymentUnitServiceName.append(new String[]{name, "expiration"}), ScheduledExecutorService.class, factory.scheduler).addDependency(deploymentUnitServiceName.append(new String[]{name, "eviction"}), Executor.class, factory.executor).addDependency(ServiceBuilder.DependencyType.OPTIONAL, ServiceName.JBOSS.append(new String[]{"clustering", "registry", containerName, "default"}), Registry.class, factory.registry).addDependency(ServiceBuilder.DependencyType.OPTIONAL, ServiceName.JBOSS.append(new String[]{"clustering", "nodes", containerName, "default"}), NodeFactory.class, factory.nodeFactory);
    }

    private InfinispanBeanManagerFactory(BeanContext context, BeanPassivationConfiguration passivationConfig) {
        this.context = context;
        this.passivationConfig = passivationConfig;
    }

    public BeanManager<G, I, T> createBeanManager(IdentifierFactory<G> groupIdentifierFactory, IdentifierFactory<I> beanIdentifierFactory, final PassivationListener<T> passivationListener, final RemoveListener<T> removeListener) {
        SimpleMarshallingContext context = new SimpleMarshallingContextFactory().createMarshallingContext((VersionedMarshallingConfiguration)this.config.getValue(), this.context.getClassLoader());
        SimpleMarshalledValueFactory factory = new SimpleMarshalledValueFactory((MarshallingContext)context);
        Cache groupCache = (Cache)this.cache.getValue();
        org.infinispan.configuration.cache.Configuration config = groupCache.getCacheConfiguration();
        InfinispanBeanGroupFactory groupFactory = new InfinispanBeanGroupFactory(groupCache, this.invoker, (MarshalledValueFactory<MarshallingContext>)factory, (MarshallingContext)context);
        SimpleConfiguration groupConfiguration = new SimpleConfiguration(groupCache, groupFactory, groupIdentifierFactory);
        Cache beanCache = (Cache)this.cache.getValue();
        String beanName = this.context.getBeanClass().getName();
        final boolean evictionAllowed = config.persistence().usingStores();
        boolean passivationEnabled = evictionAllowed && config.persistence().passivation();
        final boolean persistent = config.clustering().cacheMode().isClustered() || evictionAllowed && !passivationEnabled;
        InfinispanBeanFactory beanFactory = new InfinispanBeanFactory(beanName, groupFactory, beanCache, this.invoker, this.context.getTimeout(), persistent ? passivationListener : null);
        SimpleConfiguration beanConfiguration = new SimpleConfiguration(beanCache, beanFactory, beanIdentifierFactory);
        NodeFactory nodeFactory = (NodeFactory)this.nodeFactory.getValue();
        Registry registry = (Registry)this.registry.getValue();
        final Time timeout = this.context.getTimeout();
        final ScheduledExecutorService scheduler = (ScheduledExecutorService)this.scheduler.getValue();
        ExpirationConfiguration expiration = new ExpirationConfiguration<T>(){

            @Override
            public Time getTimeout() {
                return timeout;
            }

            @Override
            public RemoveListener<T> getRemoveListener() {
                return removeListener;
            }

            @Override
            public ScheduledExecutorService getExecutor() {
                return scheduler;
            }
        };
        final Executor executor = (Executor)this.executor.getValue();
        final BeanPassivationConfiguration passivationConfig = this.passivationConfig;
        PassivationConfiguration passivation = new PassivationConfiguration<T>(){

            @Override
            public PassivationListener<T> getPassivationListener() {
                return passivationListener;
            }

            @Override
            public boolean isEvictionAllowed() {
                return evictionAllowed;
            }

            @Override
            public boolean isPersistent() {
                return persistent;
            }

            @Override
            public BeanPassivationConfiguration getConfiguration() {
                return passivationConfig;
            }

            @Override
            public Executor getExecutor() {
                return executor;
            }
        };
        return new InfinispanBeanManager(beanName, beanConfiguration, groupConfiguration, (KeyAffinityServiceFactory)this.affinityFactory.getValue(), registry, (NodeFactory<Address>)nodeFactory, expiration, passivation);
    }

    public BeanManagerFactory<G, I, T> getValue() {
        return this;
    }

    private static class SimpleConfiguration<I, K, V, F>
    implements Configuration<I, K, V, F> {
        private final F factory;
        private final Cache<K, V> cache;
        private final IdentifierFactory<I> identifierFactory;

        SimpleConfiguration(Cache<K, V> cache, F factory, IdentifierFactory<I> identifierFactory) {
            this.factory = factory;
            this.cache = cache;
            this.identifierFactory = identifierFactory;
        }

        @Override
        public F getFactory() {
            return this.factory;
        }

        @Override
        public Cache<K, V> getCache() {
            return this.cache;
        }

        @Override
        public IdentifierFactory<I> getIdentifierFactory() {
            return this.identifierFactory;
        }
    }
}

