/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jboss.as.clustering.infinispan.subsystem.AbstractCacheConfigurationService;
import org.jboss.as.server.deployment.Services;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.Value;

public class BeanCacheConfigurationService
extends AbstractCacheConfigurationService {
    private final Value<Configuration> configuration;
    private final Value<EmbeddedCacheManager> container;

    public static String getCacheName(ServiceName deploymentUnitServiceName) {
        if (Services.JBOSS_DEPLOYMENT_SUB_UNIT.isParentOf(deploymentUnitServiceName)) {
            return deploymentUnitServiceName.getParent().getSimpleName() + "/" + deploymentUnitServiceName.getSimpleName();
        }
        return deploymentUnitServiceName.getSimpleName();
    }

    public BeanCacheConfigurationService(String name, Value<EmbeddedCacheManager> container, Value<Configuration> configuration) {
        super(name);
        this.configuration = configuration;
        this.container = container;
    }

    protected ConfigurationBuilder getConfigurationBuilder() {
        Configuration config = (Configuration)this.configuration.getValue();
        ConfigurationBuilder builder = new ConfigurationBuilder().read(config);
        builder.invocationBatching().enable();
        builder.storeAsBinary().disable().storeKeysAsBinary(false).storeValuesAsBinary(false);
        builder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
        return builder;
    }

    protected EmbeddedCacheManager getCacheContainer() {
        return (EmbeddedCacheManager)this.container.getValue();
    }
}

