/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import org.wildfly.clustering.ejb.Bean;
import org.wildfly.clustering.ejb.RemoveListener;
import org.wildfly.clustering.ejb.infinispan.BeanEntry;
import org.wildfly.clustering.ejb.infinispan.BeanFactory;
import org.wildfly.clustering.ejb.infinispan.BeanRemover;
import org.wildfly.clustering.ejb.infinispan.InfinispanEjbLogger;

public class ExpiredBeanRemover<G, I, T>
implements BeanRemover<I, T> {
    private final BeanFactory<G, I, T> factory;

    public ExpiredBeanRemover(BeanFactory<G, I, T> factory) {
        this.factory = factory;
    }

    @Override
    public void remove(I id, RemoveListener<T> listener) {
        Bean<G, I, T> bean;
        BeanEntry entry = (BeanEntry)this.factory.findValue(id);
        if (entry != null && (bean = this.factory.createBean(id, entry)).isExpired()) {
            InfinispanEjbLogger.ROOT_LOGGER.tracef("Removing expired bean %s", id);
            this.factory.remove(id, listener);
        }
    }
}

