/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.group;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.jboss.as.clustering.infinispan.invoker.Mutator;
import org.jboss.as.clustering.infinispan.invoker.Remover;
import org.jboss.as.clustering.marshalling.MarshallingContext;
import org.wildfly.clustering.ejb.PassivationListener;
import org.wildfly.clustering.ejb.infinispan.BeanGroup;
import org.wildfly.clustering.ejb.infinispan.BeanGroupEntry;
import org.wildfly.clustering.ejb.infinispan.InfinispanEjbMessages;

public class InfinispanBeanGroup<G, I, T>
implements BeanGroup<G, I, T> {
    private final G id;
    private final BeanGroupEntry<I, T> entry;
    private final MarshallingContext context;
    private final Mutator mutator;
    private final Remover<G> remover;

    public InfinispanBeanGroup(G id, BeanGroupEntry<I, T> entry, MarshallingContext context, Mutator mutator, Remover<G> remover) {
        this.id = id;
        this.entry = entry;
        this.context = context;
        this.mutator = mutator;
        this.remover = remover;
    }

    @Override
    public G getId() {
        return this.id;
    }

    private Map<I, T> beans() {
        try {
            return (Map)this.entry.getBeans().get((Object)this.context);
        }
        catch (IOException | ClassNotFoundException e) {
            throw InfinispanEjbMessages.MESSAGES.deserializationFailure(e, this.id);
        }
    }

    @Override
    public Set<I> getBeans() {
        return this.beans().keySet();
    }

    @Override
    public T getBean(I id, PassivationListener<T> listener) {
        int usage;
        T bean = this.beans().get(id);
        if (bean != null && (usage = this.entry.incrementUsage(id)) == 0 && listener != null) {
            listener.postActivate(bean);
        }
        return bean;
    }

    @Override
    public T removeBean(I id) {
        return this.beans().remove(id);
    }

    @Override
    public void addBean(I id, T bean) {
        this.beans().put(id, bean);
        this.entry.incrementUsage(id);
    }

    @Override
    public boolean releaseBean(I id, PassivationListener<T> listener) {
        boolean released;
        int usage = this.entry.decrementUsage(id);
        boolean bl = released = usage == 0;
        if (released) {
            this.prePassivate(id, listener);
        }
        return released;
    }

    @Override
    public boolean isCloseable() {
        return this.entry.totalUsage() == 0;
    }

    @Override
    public void close() {
        if (!this.beans().isEmpty()) {
            this.mutator.mutate();
        } else {
            this.remover.remove(this.id);
        }
    }

    @Override
    public void prePassivate(I id, PassivationListener<T> listener) {
        T bean;
        if (listener != null && (bean = this.beans().get(id)) != null) {
            listener.prePassivate(bean);
        }
    }

    @Override
    public void postActivate(I id, PassivationListener<T> listener) {
        T bean;
        if (listener != null && (bean = this.beans().get(id)) != null) {
            listener.postActivate(bean);
        }
    }
}

