/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.concurrent.ThreadFactory;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.clustering.concurrent.CachedThreadPoolExecutorService;
import org.jboss.as.clustering.concurrent.RemoveOnCancelScheduledExecutorService;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigurationService;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.infinispan.subsystem.GlobalComponentRegistryService;
import org.jboss.as.clustering.msc.AsynchronousService;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jboss.threads.JBossThreadFactory;
import org.jboss.tm.XAResourceRecoveryRegistry;
import org.wildfly.clustering.ejb.BeanContext;
import org.wildfly.clustering.ejb.BeanManagerFactory;
import org.wildfly.clustering.ejb.BeanManagerFactoryBuilder;
import org.wildfly.clustering.ejb.BeanManagerFactoryBuilderConfiguration;
import org.wildfly.clustering.ejb.infinispan.BeanCacheConfigurationService;
import org.wildfly.clustering.ejb.infinispan.BeanEvictionScheduler;
import org.wildfly.clustering.ejb.infinispan.BeanExpirationScheduler;
import org.wildfly.clustering.ejb.infinispan.InfinispanBeanManagerFactory;
import org.wildfly.clustering.ejb.infinispan.TransactionBatch;
import org.wildfly.security.manager.action.GetAccessControlContextAction;

public class InfinispanBeanManagerFactoryBuilder<G, I>
implements BeanManagerFactoryBuilder<G, I, TransactionBatch> {
    private static final ThreadFactory EXPIRATION_THREAD_FACTORY = new JBossThreadFactory(new ThreadGroup(BeanExpirationScheduler.class.getSimpleName()), Boolean.FALSE, null, "%G - %t", null, null, (AccessControlContext)AccessController.doPrivileged(GetAccessControlContextAction.getInstance()));
    private static final ThreadFactory EVICTION_THREAD_FACTORY = new JBossThreadFactory(new ThreadGroup(BeanEvictionScheduler.class.getSimpleName()), Boolean.FALSE, null, "%G - %t", null, null, (AccessControlContext)AccessController.doPrivileged(GetAccessControlContextAction.getInstance()));
    private final String name;
    private final BeanManagerFactoryBuilderConfiguration config;

    public InfinispanBeanManagerFactoryBuilder(String name, BeanManagerFactoryBuilderConfiguration config) {
        this.name = name;
        this.config = config;
    }

    public void installDeploymentUnitDependencies(ServiceTarget target, ServiceName deploymentUnitServiceName) {
        String cacheName = BeanCacheConfigurationService.getCacheName(deploymentUnitServiceName);
        ServiceName configurationServiceName = CacheConfigurationService.getServiceName((String)this.config.getContainerName(), (String)cacheName);
        final InjectedValue container = new InjectedValue();
        InjectedValue configuration = new InjectedValue();
        target.addService(configurationServiceName, (Service)new BeanCacheConfigurationService(cacheName, (Value<EmbeddedCacheManager>)container, (Value<Configuration>)configuration)).addDependency(EmbeddedCacheManagerService.getServiceName((String)this.config.getContainerName()), EmbeddedCacheManager.class, (Injector)container).addDependency(CacheConfigurationService.getServiceName((String)this.config.getContainerName(), (String)this.config.getCacheName()), Configuration.class, (Injector)configuration).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        ServiceName cacheServiceName = CacheService.getServiceName((String)this.config.getContainerName(), (String)cacheName);
        CacheService.Dependencies dependencies = new CacheService.Dependencies(){

            public EmbeddedCacheManager getCacheContainer() {
                return (EmbeddedCacheManager)container.getValue();
            }

            public XAResourceRecoveryRegistry getRecoveryRegistry() {
                return null;
            }
        };
        AsynchronousService.addService((ServiceTarget)target, (ServiceName)cacheServiceName, (Service)new CacheService(cacheName, dependencies)).addDependency(GlobalComponentRegistryService.getServiceName((String)this.config.getContainerName())).addDependency(configurationServiceName).addDependency(deploymentUnitServiceName.append(new String[]{"marshalling"})).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        RemoveOnCancelScheduledExecutorService.build((ServiceTarget)target, (ServiceName)deploymentUnitServiceName.append(new String[]{this.name, "expiration"}), (ThreadFactory)EXPIRATION_THREAD_FACTORY).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        CachedThreadPoolExecutorService.build((ServiceTarget)target, (ServiceName)deploymentUnitServiceName.append(new String[]{this.name, "eviction"}), (ThreadFactory)EVICTION_THREAD_FACTORY).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }

    public <T> ServiceBuilder<? extends BeanManagerFactory<G, I, T, TransactionBatch>> build(ServiceTarget target, ServiceName name, BeanContext context) {
        return InfinispanBeanManagerFactory.build(this.name, target, name, this.config, context);
    }
}

