/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.bean;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import org.jboss.as.clustering.infinispan.io.AbstractSimpleExternalizer;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanEntry;

public class InfinispanBeanEntryExternalizer<G>
extends AbstractSimpleExternalizer<InfinispanBeanEntry<G>> {
    private static final long serialVersionUID = -3454159495935772508L;

    public InfinispanBeanEntryExternalizer() {
        this(InfinispanBeanEntry.class);
    }

    private InfinispanBeanEntryExternalizer(Class targetClass) {
        super(targetClass);
    }

    public void writeObject(ObjectOutput output, InfinispanBeanEntry<G> entry) throws IOException {
        output.writeObject(entry.getGroupId());
        Date lastAccessedTime = entry.getLastAccessedTime();
        output.writeLong(lastAccessedTime != null ? lastAccessedTime.getTime() : 0L);
    }

    public InfinispanBeanEntry<G> readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        Object groupId = input.readObject();
        InfinispanBeanEntry<Object> entry = new InfinispanBeanEntry<Object>(groupId);
        long time = input.readLong();
        if (time > 0L) {
            entry.setLastAccessedTime(new Date(time));
        }
        return entry;
    }
}

