/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.as.clustering.infinispan.distribution.Locality;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.infinispan.Evictor;
import org.wildfly.clustering.ee.infinispan.TransactionBatch;
import org.wildfly.clustering.ejb.infinispan.BeanEvictionCommand;
import org.wildfly.clustering.ejb.infinispan.BeanEvictionContext;
import org.wildfly.clustering.ejb.infinispan.PassivationConfiguration;
import org.wildfly.clustering.ejb.infinispan.Scheduler;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;
import org.wildfly.clustering.group.Node;

public class BeanEvictionScheduler<I>
implements Scheduler<I>,
BeanEvictionContext<I> {
    private final Set<I> evictionQueue = new LinkedHashSet<I>();
    private final Batcher<TransactionBatch> batcher;
    private final Evictor<I> evictor;
    private final CommandDispatcher<BeanEvictionContext<I>> dispatcher;
    private final PassivationConfiguration<?> config;

    public BeanEvictionScheduler(String name, Batcher<TransactionBatch> batcher, Evictor<I> evictor, CommandDispatcherFactory dispatcherFactory, PassivationConfiguration<?> config) {
        this.batcher = batcher;
        this.evictor = evictor;
        this.config = config;
        this.dispatcher = dispatcherFactory.createCommandDispatcher((Object)name, (Object)this);
    }

    @Override
    public Batcher<TransactionBatch> getBatcher() {
        return this.batcher;
    }

    @Override
    public Evictor<I> getEvictor() {
        return this.evictor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(I id) {
        Set<I> set = this.evictionQueue;
        synchronized (set) {
            this.evictionQueue.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(Locality locality) {
        Set<I> set = this.evictionQueue;
        synchronized (set) {
            Iterator<I> beans = this.evictionQueue.iterator();
            while (beans.hasNext()) {
                I id = beans.next();
                if (locality.isLocal(id)) continue;
                beans.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(I id) {
        Set<I> set = this.evictionQueue;
        synchronized (set) {
            this.evictionQueue.add(id);
            if (this.evictionQueue.size() > this.config.getConfiguration().getMaxSize()) {
                Iterator<I> beans = this.evictionQueue.iterator();
                I bean = beans.next();
                try {
                    this.dispatcher.submitOnCluster(new BeanEvictionCommand<I>(bean), new Node[0]);
                    beans.remove();
                }
                catch (Exception e) {
                    InfinispanEjbLogger.ROOT_LOGGER.failedToPassivateBean(e, bean);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Set<I> set = this.evictionQueue;
        synchronized (set) {
            this.evictionQueue.clear();
        }
        this.dispatcher.close();
    }
}

