/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import org.jboss.as.clustering.infinispan.io.AbstractSimpleExternalizer;
import org.jboss.as.network.ClientMapping;

public class ClientMappingExternalizer
extends AbstractSimpleExternalizer<ClientMapping> {
    private static final long serialVersionUID = -826335918075494339L;

    public ClientMappingExternalizer() {
        super(ClientMapping.class);
    }

    public void writeObject(ObjectOutput output, ClientMapping mapping) throws IOException {
        byte[] address = mapping.getSourceNetworkAddress().getAddress();
        output.writeInt(address.length);
        output.write(address);
        output.writeInt(mapping.getSourceNetworkMaskBits());
        output.writeUTF(mapping.getDestinationAddress());
        output.writeInt(mapping.getDestinationPort());
    }

    public ClientMapping readObject(ObjectInput input) throws IOException {
        byte[] sourceAddress = new byte[input.readInt()];
        input.readFully(sourceAddress);
        int sourcePort = input.readInt();
        String destAddress = input.readUTF();
        int destPort = input.readInt();
        return new ClientMapping(InetAddress.getByAddress(sourceAddress), sourcePort, destAddress, destPort);
    }
}

