/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2011, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.as.clustering.ejb3.cache.backing.infinispan;

import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;
import org.jboss.logging.Messages;

/**
 * InfinispanEjbMessages
 *
 * logging id range: 10360 - 10369
 *
 * @author <a href="mailto:jperkins@redhat.com">James R. Perkins</a>
 */
@MessageBundle(projectCode = "JBAS")
public interface InfinispanEjbMessages {
    /**
     * The messages.
     */
    InfinispanEjbMessages MESSAGES = Messages.getBundle(InfinispanEjbMessages.class);

    @Message(id = 10360, value = "Failed to serialize %s")
    IllegalArgumentException serializationFailure(@Cause Throwable cause, Object key);

    @Message(id = 10361, value = "Failed to deserialize %s")
    IllegalArgumentException deserializationFailure(@Cause Throwable cause, Object key);

    @Message(id = 10362, value = "Failed to acquire ownership of %s within %d ms")
    RuntimeException lockAcquisitionTimeout(Object key, long timeout);

    @Message(id = 10363, value = "Interrupted while acquiring ownership of %s")
    RuntimeException lockAcquisitionInterruption(@Cause Throwable cause, Object key);

    @Message(id = 10364, value = "Failed to load infinispan cache store")
    RuntimeException cacheLoaderFailure(@Cause Throwable cause);
}
