/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.jboss.as.clustering.infinispan.subsystem.CacheAddHandler;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerAddHandler;
import org.jboss.as.clustering.infinispan.subsystem.CacheType;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class CacheContainerRemoveHandler
extends AbstractRemoveStepHandler {
    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        for (CacheType type : CacheType.values()) {
            CacheAddHandler addHandler = type.getAddHandler();
            if (!model.hasDefined(type.pathElement().getKey())) continue;
            for (Property property : model.get(type.pathElement().getKey()).asPropertyList()) {
                ModelNode removeOperation = Util.createRemoveOperation((PathAddress)address.append(new PathElement[]{type.pathElement(property.getName())}));
                addHandler.removeRuntimeServices(context, removeOperation, model, property.getValue());
            }
        }
        CacheContainerAddHandler.removeRuntimeServices(context, operation, model);
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        CacheContainerAddHandler.installRuntimeServices(context, operation, model);
        for (CacheType type : CacheType.values()) {
            CacheAddHandler addHandler = type.getAddHandler();
            if (!model.hasDefined(type.pathElement().getKey())) continue;
            for (Property property : model.get(type.pathElement().getKey()).asPropertyList()) {
                ModelNode addOperation = Util.createAddOperation((PathAddress)address.append(new PathElement[]{type.pathElement(property.getName())}));
                addHandler.installRuntimeServices(context, addOperation, model, property.getValue());
            }
        }
    }
}

