/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.jboss.as.clustering.controller.MetricExecutor;
import org.jboss.as.clustering.controller.MetricHandler;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.clustering.controller.transform.OperationTransformer;
import org.jboss.as.clustering.controller.transform.SimpleOperationTransformer;
import org.jboss.as.clustering.controller.validation.ModuleIdentifierValidator;
import org.jboss.as.clustering.infinispan.subsystem.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerAddHandler;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerMetric;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerMetricExecutor;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerRemoveHandler;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanModel;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanResourceDescriptionResolver;
import org.jboss.as.clustering.infinispan.subsystem.InvalidationCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.LocalCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ReplicatedCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StartMode;
import org.jboss.as.clustering.infinispan.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.global.ListOperations;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class CacheContainerResourceDefinition
extends SimpleResourceDefinition {
    static final PathElement WILDCARD_PATH = CacheContainerResourceDefinition.pathElement("*");
    static final StringListAttributeDefinition ALIASES = ((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("aliases").setAllowNull(true)).build();
    static final SimpleAttributeDefinition MODULE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("module", ModelType.STRING, true).setXmlName(Attribute.MODULE.getLocalName())).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new ModuleIdentifierValidator(true))).setDefaultValue(new ModelNode().set("org.jboss.as.clustering.infinispan"))).build();
    static final SimpleAttributeDefinition DEFAULT_CACHE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("default-cache", ModelType.STRING, true).setXmlName(Attribute.DEFAULT_CACHE.getLocalName())).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    static final SimpleAttributeDefinition EVICTION_EXECUTOR = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("eviction-executor", ModelType.STRING, true).setXmlName(Attribute.EVICTION_EXECUTOR.getLocalName())).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDeprecated(InfinispanModel.VERSION_3_0_0.getVersion())).build();
    static final SimpleAttributeDefinition JNDI_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("jndi-name", ModelType.STRING, true).setXmlName(Attribute.JNDI_NAME.getLocalName())).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    static final SimpleAttributeDefinition LISTENER_EXECUTOR = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("listener-executor", ModelType.STRING, true).setXmlName(Attribute.LISTENER_EXECUTOR.getLocalName())).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDeprecated(InfinispanModel.VERSION_3_0_0.getVersion())).build();
    static final SimpleAttributeDefinition REPLICATION_QUEUE_EXECUTOR = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("replication-queue-executor", ModelType.STRING, true).setXmlName(Attribute.REPLICATION_QUEUE_EXECUTOR.getLocalName())).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDeprecated(InfinispanModel.VERSION_3_0_0.getVersion())).build();
    static final SimpleAttributeDefinition START = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("start", ModelType.STRING, true).setXmlName(Attribute.START.getLocalName())).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new EnumValidator(StartMode.class, true, false))).setDefaultValue(new ModelNode().set(StartMode.LAZY.name()))).setDeprecated(InfinispanModel.VERSION_3_0_0.getVersion())).build();
    static final SimpleAttributeDefinition STATISTICS_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("statistics-enabled", ModelType.BOOLEAN, true).setXmlName(Attribute.STATISTICS_ENABLED.getLocalName())).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setDefaultValue(new ModelNode().set(false))).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{DEFAULT_CACHE, ALIASES, JNDI_NAME, START, LISTENER_EXECUTOR, EVICTION_EXECUTOR, REPLICATION_QUEUE_EXECUTOR, MODULE, STATISTICS_ENABLED};
    static final AttributeDefinition ALIAS = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name", ModelType.STRING).setAllowExpression(false)).build();
    static final OperationDefinition ALIAS_ADD = new SimpleOperationDefinitionBuilder("add-alias", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache-container")).setParameters(new AttributeDefinition[]{ALIAS}).setDeprecated(InfinispanModel.VERSION_3_0_0.getVersion()).build();
    static final OperationDefinition ALIAS_REMOVE = new SimpleOperationDefinitionBuilder("remove-alias", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache-container")).setParameters(new AttributeDefinition[]{ALIAS}).setDeprecated(InfinispanModel.VERSION_3_0_0.getVersion()).build();
    private final PathManager pathManager;
    private final boolean allowRuntimeOnlyRegistration;

    static PathElement pathElement(String containerName) {
        return PathElement.pathElement((String)"cache-container", (String)containerName);
    }

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder builder = parent.addChildResource(WILDCARD_PATH);
        if (InfinispanModel.VERSION_3_0_0.requiresTransformation(version)) {
            OperationTransformer addAliasTransformer = new OperationTransformer(){

                public ModelNode transformOperation(ModelNode operation) {
                    String attributeName = Operations.getAttributeName((ModelNode)operation);
                    if (ALIASES.getName().equals(attributeName)) {
                        ModelNode value = Operations.getAttributeValue((ModelNode)operation);
                        PathAddress address = Operations.getPathAddress((ModelNode)operation);
                        ModelNode transformedOperation = Util.createOperation((OperationDefinition)ALIAS_ADD, (PathAddress)address);
                        transformedOperation.get(ALIAS.getName()).set(value);
                        return transformedOperation;
                    }
                    return operation;
                }
            };
            builder.addRawOperationTransformationOverride(ListOperations.LIST_ADD_DEFINITION.getName(), (org.jboss.as.controller.transform.OperationTransformer)new SimpleOperationTransformer(addAliasTransformer));
            OperationTransformer removeAliasTransformer = new OperationTransformer(){

                public ModelNode transformOperation(ModelNode operation) {
                    String attributeName = Operations.getAttributeName((ModelNode)operation);
                    if (ALIASES.getName().equals(attributeName)) {
                        ModelNode value = Operations.getAttributeValue((ModelNode)operation);
                        PathAddress address = Operations.getPathAddress((ModelNode)operation);
                        ModelNode transformedOperation = Util.createOperation((OperationDefinition)ALIAS_REMOVE, (PathAddress)address);
                        transformedOperation.get(ALIAS.getName()).set(value);
                        return transformedOperation;
                    }
                    return operation;
                }
            };
            builder.addRawOperationTransformationOverride(ListOperations.LIST_REMOVE_DEFINITION.getName(), (org.jboss.as.controller.transform.OperationTransformer)new SimpleOperationTransformer(removeAliasTransformer));
        }
        if (InfinispanModel.VERSION_1_5_0.requiresTransformation(version)) {
            ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(false, false, new ModelNode[]{new ModelNode(true)}), new AttributeDefinition[]{STATISTICS_ENABLED})).addRejectCheck(RejectAttributeChecker.UNDEFINED, new AttributeDefinition[]{STATISTICS_ENABLED})).addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{STATISTICS_ENABLED})).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.SimpleRejectAttributeChecker(new ModelNode(false)), new AttributeDefinition[]{STATISTICS_ENABLED});
        }
        TransportResourceDefinition.buildTransformation(version, builder);
        DistributedCacheResourceDefinition.buildTransformation(version, builder);
        ReplicatedCacheResourceDefinition.buildTransformation(version, builder);
        InvalidationCacheResourceDefinition.buildTransformation(version, builder);
        LocalCacheResourceDefinition.buildTransformation(version, builder);
    }

    CacheContainerResourceDefinition(PathManager pathManager, boolean allowRuntimeOnlyRegistration) {
        super(WILDCARD_PATH, (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache-container"), (OperationStepHandler)new CacheContainerAddHandler(), (OperationStepHandler)new CacheContainerRemoveHandler());
        this.pathManager = pathManager;
        this.allowRuntimeOnlyRegistration = allowRuntimeOnlyRegistration;
    }

    public void registerAttributes(ManagementResourceRegistration registration) {
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attr : ATTRIBUTES) {
            registration.registerReadWriteAttribute(attr, null, (OperationStepHandler)writeHandler);
        }
        if (this.allowRuntimeOnlyRegistration) {
            new MetricHandler((MetricExecutor)new CacheContainerMetricExecutor(), CacheContainerMetric.class).register(registration);
        }
    }

    public void registerOperations(ManagementResourceRegistration registration) {
        super.registerOperations(registration);
        OperationStepHandler addAliasHandler = new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode legacyOperation) {
                String value = legacyOperation.get(ALIAS.getName()).asString();
                ModelNode operation = Operations.createListAddOperation((PathAddress)context.getCurrentAddress(), (String)ALIASES.getName(), (String)value);
                context.addStep(operation, ListOperations.LIST_ADD_HANDLER, context.getCurrentStage());
            }
        };
        registration.registerOperationHandler(ALIAS_ADD, addAliasHandler);
        OperationStepHandler removeAliasHandler = new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode legacyOperation) throws OperationFailedException {
                String value = legacyOperation.get(ALIAS.getName()).asString();
                ModelNode operation = Operations.createListRemoveOperation((PathAddress)context.getCurrentAddress(), (String)ALIASES.getName(), (String)value);
                context.addStep(operation, ListOperations.LIST_REMOVE_HANDLER, context.getCurrentStage());
            }
        };
        registration.registerOperationHandler(ALIAS_REMOVE, removeAliasHandler);
    }

    public void registerChildren(ManagementResourceRegistration registration) {
        registration.registerSubModel((ResourceDefinition)new TransportResourceDefinition());
        registration.registerSubModel((ResourceDefinition)new LocalCacheResourceDefinition(this.pathManager, this.allowRuntimeOnlyRegistration));
        registration.registerSubModel((ResourceDefinition)new InvalidationCacheResourceDefinition(this.pathManager, this.allowRuntimeOnlyRegistration));
        registration.registerSubModel((ResourceDefinition)new ReplicatedCacheResourceDefinition(this.pathManager, this.allowRuntimeOnlyRegistration));
        registration.registerSubModel((ResourceDefinition)new DistributedCacheResourceDefinition(this.pathManager, this.allowRuntimeOnlyRegistration));
    }
}

