/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.infinispan.transaction.LockingMode;
import org.jboss.as.clustering.controller.MetricExecutor;
import org.jboss.as.clustering.controller.MetricHandler;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.clustering.controller.ReloadRequiredAddStepHandler;
import org.jboss.as.clustering.controller.transform.AttributeOperationTransformer;
import org.jboss.as.clustering.controller.transform.ChainedOperationTransformer;
import org.jboss.as.clustering.controller.transform.SimpleOperationTransformer;
import org.jboss.as.clustering.infinispan.subsystem.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanModel;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanResourceDescriptionResolver;
import org.jboss.as.clustering.infinispan.subsystem.TransactionMetric;
import org.jboss.as.clustering.infinispan.subsystem.TransactionMetricExecutor;
import org.jboss.as.clustering.infinispan.subsystem.TransactionMode;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class TransactionResourceDefinition
extends SimpleResourceDefinition {
    static final PathElement PATH = PathElement.pathElement((String)"transaction", (String)"TRANSACTION");
    static final SimpleAttributeDefinition LOCKING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("locking", ModelType.STRING, true).setXmlName(Attribute.LOCKING.getLocalName())).setAllowExpression(true)).setValidator((ParameterValidator)new EnumValidator(LockingMode.class, true, false))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode().set(LockingMode.PESSIMISTIC.name()))).build();
    static final SimpleAttributeDefinition MODE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("mode", ModelType.STRING, true).setXmlName(Attribute.MODE.getLocalName())).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new EnumValidator(TransactionMode.class, true, true))).setDefaultValue(new ModelNode().set(TransactionMode.DEFAULT.name()))).build();
    static final SimpleAttributeDefinition STOP_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("stop-timeout", ModelType.LONG, true).setXmlName(Attribute.STOP_TIMEOUT.getLocalName())).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode().set(30000))).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{MODE, STOP_TIMEOUT, LOCKING};
    private final boolean allowRuntimeOnlyRegistration;

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder builder = parent.addChildResource(PATH);
        LinkedList<OperationTransformer> addOperationTransformers = new LinkedList<OperationTransformer>();
        LinkedList<OperationTransformer> removeOperationTransformers = new LinkedList<OperationTransformer>();
        HashMap<String, OperationTransformer> readAttributeTransformers = new HashMap<String, OperationTransformer>();
        HashMap<String, OperationTransformer> writeAttributeTransformers = new HashMap<String, OperationTransformer>();
        HashMap<String, OperationTransformer> undefineAttributeTransformers = new HashMap<String, OperationTransformer>();
        if (InfinispanModel.VERSION_3_0_0.requiresTransformation(version)) {
            org.jboss.as.clustering.controller.transform.OperationTransformer addTransformer = new org.jboss.as.clustering.controller.transform.OperationTransformer(){

                public ModelNode transformOperation(ModelNode operation) {
                    ModelNode mode;
                    if (operation.hasDefined(MODE.getName()) && (mode = operation.get(MODE.getName())).getType() == ModelType.STRING && TransactionMode.valueOf(mode.asString()) == TransactionMode.BATCH) {
                        mode.set(TransactionMode.NONE.name());
                        PathAddress address = Operations.getPathAddress((ModelNode)operation);
                        return Operations.createCompositeOperation((ModelNode[])new ModelNode[]{operation, Operations.createWriteAttributeOperation((PathAddress)TransactionResourceDefinition.cacheAddress(address), (String)CacheResourceDefinition.BATCHING.getName(), (ModelNode)new ModelNode(true))});
                    }
                    return operation;
                }
            };
            addOperationTransformers.add((OperationTransformer)new SimpleOperationTransformer(addTransformer));
            org.jboss.as.clustering.controller.transform.OperationTransformer removeTransformer = new org.jboss.as.clustering.controller.transform.OperationTransformer(){

                public ModelNode transformOperation(ModelNode operation) {
                    PathAddress address = Operations.getPathAddress((ModelNode)operation);
                    return Operations.createCompositeOperation((ModelNode[])new ModelNode[]{operation, Operations.createUndefineAttributeOperation((PathAddress)TransactionResourceDefinition.cacheAddress(address), (String)CacheResourceDefinition.BATCHING.getName())});
                }
            };
            removeOperationTransformers.add((OperationTransformer)new SimpleOperationTransformer(removeTransformer));
            org.jboss.as.clustering.controller.transform.OperationTransformer readAttributeOperationTransformer = new org.jboss.as.clustering.controller.transform.OperationTransformer(){

                public ModelNode transformOperation(ModelNode operation) {
                    PathAddress address = Operations.getPathAddress((ModelNode)operation);
                    return Operations.createCompositeOperation((ModelNode[])new ModelNode[]{Operations.createReadAttributeOperation((PathAddress)TransactionResourceDefinition.cacheAddress(address), (String)CacheResourceDefinition.BATCHING.getName()), operation});
                }
            };
            OperationResultTransformer readAttributeResultTransformer = new OperationResultTransformer(){

                public ModelNode transformResult(ModelNode result) {
                    ModelNode readBatchingResult = result.get(0);
                    return readBatchingResult.asBoolean() ? new ModelNode(TransactionMode.BATCH.name()) : result.get(1);
                }
            };
            readAttributeTransformers.put(MODE.getName(), (OperationTransformer)new SimpleOperationTransformer(readAttributeOperationTransformer, readAttributeResultTransformer));
            org.jboss.as.clustering.controller.transform.OperationTransformer writeAttributeTransformer = new org.jboss.as.clustering.controller.transform.OperationTransformer(){

                public ModelNode transformOperation(ModelNode operation) {
                    boolean batching;
                    ModelNode mode = Operations.getAttributeValue((ModelNode)operation);
                    boolean bl = mode.isDefined() && mode.getType() == ModelType.STRING ? TransactionMode.valueOf(mode.asString()) == TransactionMode.BATCH : (batching = false);
                    if (batching) {
                        mode.set(TransactionMode.NONE.name());
                    }
                    PathAddress address = Operations.getPathAddress((ModelNode)operation);
                    return Operations.createCompositeOperation((ModelNode[])new ModelNode[]{operation, Operations.createWriteAttributeOperation((PathAddress)TransactionResourceDefinition.cacheAddress(address), (String)CacheResourceDefinition.BATCHING.getName(), (ModelNode)new ModelNode(batching))});
                }
            };
            writeAttributeTransformers.put(MODE.getName(), (OperationTransformer)new SimpleOperationTransformer(writeAttributeTransformer));
            org.jboss.as.clustering.controller.transform.OperationTransformer undefineAttributeTransformer = new org.jboss.as.clustering.controller.transform.OperationTransformer(){

                public ModelNode transformOperation(ModelNode operation) {
                    PathAddress address = Operations.getPathAddress((ModelNode)operation);
                    return Operations.createCompositeOperation((ModelNode[])new ModelNode[]{operation, Operations.createUndefineAttributeOperation((PathAddress)TransactionResourceDefinition.cacheAddress(address), (String)CacheResourceDefinition.BATCHING.getName())});
                }
            };
            undefineAttributeTransformers.put(MODE.getName(), (OperationTransformer)new SimpleOperationTransformer(undefineAttributeTransformer));
            ResourceTransformer modeTransformer = new ResourceTransformer(){

                public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
                    ModelNode value;
                    ModelNode model = resource.getModel();
                    if (model.hasDefined(MODE.getName()) && (value = model.get(MODE.getName())).getType() == ModelType.STRING && TransactionMode.valueOf(value.asString()) == TransactionMode.BATCH) {
                        value.set(TransactionMode.NONE.name());
                    }
                    context.addTransformedResource(PathAddress.EMPTY_ADDRESS, resource).processChildren(resource);
                }
            };
            builder.setCustomResourceTransformer(modeTransformer);
        }
        TransactionResourceDefinition.buildOperationTransformation(builder, "add", addOperationTransformers);
        TransactionResourceDefinition.buildOperationTransformation(builder, "remove", removeOperationTransformers);
        TransactionResourceDefinition.buildOperationTransformation(builder, "read-attribute", readAttributeTransformers);
        TransactionResourceDefinition.buildOperationTransformation(builder, "write-attribute", writeAttributeTransformers);
        TransactionResourceDefinition.buildOperationTransformation(builder, "undefine-attribute", undefineAttributeTransformers);
    }

    static void buildOperationTransformation(ResourceTransformationDescriptionBuilder builder, String operationName, List<OperationTransformer> transformers) {
        if (!transformers.isEmpty()) {
            builder.addOperationTransformationOverride(operationName).setCustomOperationTransformer((OperationTransformer)new ChainedOperationTransformer(transformers)).inheritResourceAttributeDefinitions();
        }
    }

    static void buildOperationTransformation(ResourceTransformationDescriptionBuilder builder, String operationName, Map<String, OperationTransformer> transformers) {
        if (!transformers.isEmpty()) {
            builder.addOperationTransformationOverride(operationName).setCustomOperationTransformer((OperationTransformer)new AttributeOperationTransformer(transformers)).inheritResourceAttributeDefinitions();
        }
    }

    static PathAddress cacheAddress(PathAddress transactionAddress) {
        return transactionAddress.subAddress(0, transactionAddress.size() - 1);
    }

    TransactionResourceDefinition(boolean allowRuntimeOnlyRegistration) {
        super(PATH, (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("transaction"), (OperationStepHandler)new ReloadRequiredAddStepHandler(ATTRIBUTES), (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
        this.allowRuntimeOnlyRegistration = allowRuntimeOnlyRegistration;
    }

    public void registerAttributes(ManagementResourceRegistration registration) {
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attr : ATTRIBUTES) {
            registration.registerReadWriteAttribute(attr, null, (OperationStepHandler)writeHandler);
        }
        if (this.allowRuntimeOnlyRegistration) {
            new MetricHandler((MetricExecutor)new TransactionMetricExecutor(), TransactionMetric.class).register(registration);
        }
    }
}

