/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

public enum InfinispanSchema {
    VERSION_1_0(1, 0),
    VERSION_1_1(1, 1),
    VERSION_1_2(1, 2),
    VERSION_1_3(1, 3),
    VERSION_1_4(1, 4),
    VERSION_1_5(1, 5),
    VERSION_2_0(2, 0),
    VERSION_3_0(3, 0);

    static final InfinispanSchema CURRENT;
    private final int major;
    private final int minor;

    private InfinispanSchema(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public boolean since(InfinispanSchema schema) {
        return this.major > schema.major || this.major == schema.major && this.minor >= schema.minor;
    }

    public String getNamespaceUri() {
        return this.format("urn:jboss:domain:infinispan:%d.%d");
    }

    String format(String pattern) {
        return String.format(pattern, this.major, this.minor);
    }

    static {
        CURRENT = VERSION_3_0;
    }
}

