/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.LinkedList;
import java.util.List;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStarted;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStartedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.jboss.as.clustering.infinispan.DefaultCacheContainer;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.infinispan.spi.CacheContainer;
import org.wildfly.clustering.infinispan.spi.service.CacheContainerServiceName;
import org.wildfly.clustering.service.Builder;

@Listener
public class CacheContainerBuilder
implements Builder<CacheContainer>,
Service<CacheContainer> {
    private final InjectedValue<GlobalConfiguration> configuration = new InjectedValue();
    private final List<String> aliases = new LinkedList<String>();
    private final String name;
    private final String defaultCache;
    private volatile CacheContainer container;

    public CacheContainerBuilder(String name, String defaultCache) {
        this.name = name;
        this.defaultCache = defaultCache;
    }

    public ServiceName getServiceName() {
        return CacheContainerServiceName.CACHE_CONTAINER.getServiceName(this.name);
    }

    public ServiceBuilder<CacheContainer> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName(), (Service)this).addDependency(CacheContainerServiceName.CONFIGURATION.getServiceName(this.name), GlobalConfiguration.class, this.configuration);
        for (String alias : this.aliases) {
            builder.addAliases(new ServiceName[]{CacheContainerServiceName.CACHE_CONTAINER.getServiceName(alias)});
        }
        return builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public CacheContainerBuilder addAlias(String alias) {
        this.aliases.add(alias);
        return this;
    }

    public CacheContainer getValue() {
        return this.container;
    }

    public void start(StartContext context) {
        GlobalConfiguration config = (GlobalConfiguration)this.configuration.getValue();
        this.container = new DefaultCacheContainer(config, this.defaultCache);
        this.container.addListener((Object)this);
        this.container.start();
        InfinispanLogger.ROOT_LOGGER.debugf("%s cache container started", this.name);
    }

    public void stop(StopContext context) {
        if (this.container != null && this.container.getStatus().allowInvocations()) {
            this.container.stop();
            this.container.removeListener((Object)this);
            InfinispanLogger.ROOT_LOGGER.debugf("%s cache container stopped", this.name);
        }
    }

    @CacheStarted
    public void cacheStarted(CacheStartedEvent event) {
        InfinispanLogger.ROOT_LOGGER.cacheStarted(event.getCacheName(), this.name);
    }

    @CacheStopped
    public void cacheStopped(CacheStoppedEvent event) {
        InfinispanLogger.ROOT_LOGGER.cacheStopped(event.getCacheName(), this.name);
    }
}

