/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.jboss.as.clustering.controller.AddStepHandler;
import org.jboss.as.clustering.controller.AttributeParsers;
import org.jboss.as.clustering.controller.MetricExecutor;
import org.jboss.as.clustering.controller.MetricHandler;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.clustering.controller.Registration;
import org.jboss.as.clustering.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.clustering.controller.RemoveStepHandler;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.transform.OperationTransformer;
import org.jboss.as.clustering.controller.transform.SimpleOperationTransformer;
import org.jboss.as.clustering.controller.validation.ModuleIdentifierValidator;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerMetric;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerMetricExecutor;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerServiceHandler;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanModel;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanResourceDescriptionResolver;
import org.jboss.as.clustering.infinispan.subsystem.InvalidationCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.JGroupsTransportResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.LocalCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.NoTransportResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ReplicatedCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StartMode;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.global.ListOperations;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class CacheContainerResourceDefinition
extends SimpleResourceDefinition
implements Registration {
    static final PathElement WILDCARD_PATH = CacheContainerResourceDefinition.pathElement("*");
    static final AttributeDefinition ALIAS = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name", ModelType.STRING).setAllowExpression(false)).build();
    static final OperationDefinition ALIAS_ADD = new SimpleOperationDefinitionBuilder("add-alias", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver(WILDCARD_PATH)).setParameters(new AttributeDefinition[]{ALIAS}).setDeprecated(InfinispanModel.VERSION_3_0_0.getVersion()).build();
    static final OperationDefinition ALIAS_REMOVE = new SimpleOperationDefinitionBuilder("remove-alias", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver(WILDCARD_PATH)).setParameters(new AttributeDefinition[]{ALIAS}).setDeprecated(InfinispanModel.VERSION_3_0_0.getVersion()).build();
    private final PathManager pathManager;
    private final boolean allowRuntimeOnlyRegistration;

    static PathElement pathElement(String containerName) {
        return PathElement.pathElement((String)"cache-container", (String)containerName);
    }

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder builder = parent.addChildResource(WILDCARD_PATH);
        if (InfinispanModel.VERSION_4_0_0.requiresTransformation(version)) {
            builder.discardChildResource(NoTransportResourceDefinition.PATH);
        } else {
            NoTransportResourceDefinition.buildTransformation(version, builder);
        }
        if (InfinispanModel.VERSION_3_0_0.requiresTransformation(version)) {
            OperationTransformer addAliasTransformer = new OperationTransformer(){

                public ModelNode transformOperation(ModelNode operation) {
                    String attributeName = Operations.getAttributeName((ModelNode)operation);
                    if (Attribute.ALIASES.getDefinition().getName().equals(attributeName)) {
                        ModelNode value = Operations.getAttributeValue((ModelNode)operation);
                        PathAddress address = Operations.getPathAddress((ModelNode)operation);
                        ModelNode transformedOperation = Util.createOperation((OperationDefinition)ALIAS_ADD, (PathAddress)address);
                        transformedOperation.get(ALIAS.getName()).set(value);
                        return transformedOperation;
                    }
                    return operation;
                }
            };
            builder.addRawOperationTransformationOverride(ListOperations.LIST_ADD_DEFINITION.getName(), (org.jboss.as.controller.transform.OperationTransformer)new SimpleOperationTransformer(addAliasTransformer));
            OperationTransformer removeAliasTransformer = new OperationTransformer(){

                public ModelNode transformOperation(ModelNode operation) {
                    String attributeName = Operations.getAttributeName((ModelNode)operation);
                    if (Attribute.ALIASES.getDefinition().getName().equals(attributeName)) {
                        ModelNode value = Operations.getAttributeValue((ModelNode)operation);
                        PathAddress address = Operations.getPathAddress((ModelNode)operation);
                        ModelNode transformedOperation = Util.createOperation((OperationDefinition)ALIAS_REMOVE, (PathAddress)address);
                        transformedOperation.get(ALIAS.getName()).set(value);
                        return transformedOperation;
                    }
                    return operation;
                }
            };
            builder.addRawOperationTransformationOverride(ListOperations.LIST_REMOVE_DEFINITION.getName(), (org.jboss.as.controller.transform.OperationTransformer)new SimpleOperationTransformer(removeAliasTransformer));
        }
        if (InfinispanModel.VERSION_1_5_0.requiresTransformation(version)) {
            ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(false, false, new ModelNode[]{new ModelNode(true)}), new AttributeDefinition[]{Attribute.STATISTICS_ENABLED.getDefinition()})).addRejectCheck(RejectAttributeChecker.UNDEFINED, new AttributeDefinition[]{Attribute.STATISTICS_ENABLED.getDefinition()})).addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{Attribute.STATISTICS_ENABLED.getDefinition()})).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.SimpleRejectAttributeChecker(new ModelNode(false)), new AttributeDefinition[]{Attribute.STATISTICS_ENABLED.getDefinition()});
        }
        JGroupsTransportResourceDefinition.buildTransformation(version, builder);
        DistributedCacheResourceDefinition.buildTransformation(version, builder);
        ReplicatedCacheResourceDefinition.buildTransformation(version, builder);
        InvalidationCacheResourceDefinition.buildTransformation(version, builder);
        LocalCacheResourceDefinition.buildTransformation(version, builder);
    }

    CacheContainerResourceDefinition(PathManager pathManager, boolean allowRuntimeOnlyRegistration) {
        super(WILDCARD_PATH, (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver(WILDCARD_PATH));
        this.pathManager = pathManager;
        this.allowRuntimeOnlyRegistration = allowRuntimeOnlyRegistration;
    }

    public void registerAttributes(ManagementResourceRegistration registration) {
        new ReloadRequiredWriteAttributeHandler(Attribute.class).register(registration);
        if (this.allowRuntimeOnlyRegistration) {
            new MetricHandler((MetricExecutor)new CacheContainerMetricExecutor(), CacheContainerMetric.class).register(registration);
        }
    }

    public void registerOperations(ManagementResourceRegistration registration) {
        CacheContainerServiceHandler handler = new CacheContainerServiceHandler();
        new AddStepHandler(this.getResourceDescriptionResolver(), (ResourceServiceHandler)handler).addAttributes(Attribute.class).register(registration);
        new RemoveStepHandler(this.getResourceDescriptionResolver(), (ResourceServiceHandler)handler).register(registration);
        OperationStepHandler addAliasHandler = new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode legacyOperation) {
                String value = legacyOperation.get(ALIAS.getName()).asString();
                ModelNode operation = Operations.createListAddOperation((PathAddress)context.getCurrentAddress(), (org.jboss.as.clustering.controller.Attribute)Attribute.ALIASES, (String)value);
                context.addStep(operation, ListOperations.LIST_ADD_HANDLER, context.getCurrentStage());
            }
        };
        registration.registerOperationHandler(ALIAS_ADD, addAliasHandler);
        OperationStepHandler removeAliasHandler = new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode legacyOperation) throws OperationFailedException {
                String value = legacyOperation.get(ALIAS.getName()).asString();
                ModelNode operation = Operations.createListRemoveOperation((PathAddress)context.getCurrentAddress(), (org.jboss.as.clustering.controller.Attribute)Attribute.ALIASES, (String)value);
                context.addStep(operation, ListOperations.LIST_REMOVE_HANDLER, context.getCurrentStage());
            }
        };
        registration.registerOperationHandler(ALIAS_REMOVE, removeAliasHandler);
    }

    public void registerChildren(ManagementResourceRegistration registration) {
        new JGroupsTransportResourceDefinition().register(registration);
        new NoTransportResourceDefinition().register(registration);
        new LocalCacheResourceDefinition(this.pathManager, this.allowRuntimeOnlyRegistration).register(registration);
        new InvalidationCacheResourceDefinition(this.pathManager, this.allowRuntimeOnlyRegistration).register(registration);
        new ReplicatedCacheResourceDefinition(this.pathManager, this.allowRuntimeOnlyRegistration).register(registration);
        new DistributedCacheResourceDefinition(this.pathManager, this.allowRuntimeOnlyRegistration).register(registration);
    }

    public void register(ManagementResourceRegistration registration) {
        registration.registerSubModel((ResourceDefinition)this);
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute
    {
        ALIASES("aliases"),
        MODULE("module", ModelType.STRING, new ModelNode("org.jboss.as.clustering.infinispan"), (ParameterValidator)new ModuleIdentifierValidator(true, true)),
        DEFAULT_CACHE("default-cache", ModelType.STRING, null, null),
        EVICTION_EXECUTOR("eviction-executor", ModelType.STRING, null, null, InfinispanModel.VERSION_3_0_0),
        JNDI_NAME("jndi-name", ModelType.STRING, null, null),
        LISTENER_EXECUTOR("listener-executor", ModelType.STRING, null, null, InfinispanModel.VERSION_3_0_0),
        REPLICATION_QUEUE_EXECUTOR("replication-queue-executor", ModelType.STRING, null, null, InfinispanModel.VERSION_3_0_0),
        START("start", ModelType.STRING, new ModelNode(StartMode.LAZY.name()), (ParameterValidator)new EnumValidator(StartMode.class, true, true), InfinispanModel.VERSION_3_0_0),
        STATISTICS_ENABLED("statistics-enabled", ModelType.BOOLEAN, new ModelNode(false), null);

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, ModelNode defaultValue, ParameterValidator validator) {
            this.definition = Attribute.createBuilder(name, type, defaultValue, validator).build();
        }

        private Attribute(String name, ModelType type, ModelNode defaultValue, ParameterValidator validator, InfinispanModel deprecation) {
            this.definition = ((SimpleAttributeDefinitionBuilder)Attribute.createBuilder(name, type, defaultValue, validator).setDeprecated(deprecation.getVersion())).build();
        }

        private static SimpleAttributeDefinitionBuilder createBuilder(String name, ModelType type, ModelNode defaultValue, ParameterValidator validator) {
            return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setAllowNull(true)).setDefaultValue(defaultValue)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setValidator(validator);
        }

        private Attribute(String name) {
            this.definition = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder(name).setAllowNull(true)).setAttributeParser(AttributeParsers.COLLECTION)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

