/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.configuration.cache.ExpirationConfigurationBuilder;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponentBuilder;
import org.jboss.as.clustering.infinispan.subsystem.ExpirationResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.service.Builder;

public class ExpirationBuilder
extends CacheComponentBuilder<ExpirationConfiguration>
implements ResourceServiceBuilder<ExpirationConfiguration> {
    private final ExpirationConfigurationBuilder builder = new ConfigurationBuilder().expiration();

    ExpirationBuilder(String containerName, String cacheName) {
        super(CacheComponent.EXPIRATION, containerName, cacheName);
    }

    public Builder<ExpirationConfiguration> configure(ExpressionResolver resolver, ModelNode model) throws OperationFailedException {
        this.builder.wakeUpInterval(ExpirationResourceDefinition.Attribute.INTERVAL.getDefinition().resolveModelAttribute(resolver, model).asLong());
        this.builder.lifespan(ExpirationResourceDefinition.Attribute.LIFESPAN.getDefinition().resolveModelAttribute(resolver, model).asLong());
        this.builder.maxIdle(ExpirationResourceDefinition.Attribute.MAX_IDLE.getDefinition().resolveModelAttribute(resolver, model).asLong());
        return this;
    }

    public ExpirationConfiguration getValue() {
        return this.builder.create();
    }
}

