/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.Index;
import org.jboss.as.clustering.controller.AddStepHandler;
import org.jboss.as.clustering.controller.AttributeMarshallers;
import org.jboss.as.clustering.controller.AttributeParsers;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.clustering.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.clustering.controller.RemoveStepHandler;
import org.jboss.as.clustering.controller.ResourceServiceBuilderFactory;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleResourceServiceHandler;
import org.jboss.as.clustering.controller.transform.SimpleOperationTransformer;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ComponentResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.IndexingBuilderFactory;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanModel;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class IndexingResourceDefinition
extends ComponentResourceDefinition {
    static final PathElement PATH = IndexingResourceDefinition.pathElement("indexing");

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder builder = parent.addChildResource(PATH);
        if (InfinispanModel.VERSION_4_0_0.requiresTransformation(version)) {
            org.jboss.as.clustering.controller.transform.OperationTransformer addTransformer = new org.jboss.as.clustering.controller.transform.OperationTransformer(){

                public ModelNode transformOperation(ModelNode operation) {
                    PathAddress cacheAddress = Operations.getPathAddress((ModelNode)operation).getParent();
                    ModelNode indexOperation = this.translateParameter(cacheAddress, operation, Attribute.INDEX, CacheResourceDefinition.Attribute.INDEXING);
                    ModelNode propertiesOperation = this.translateParameter(cacheAddress, operation, Attribute.PROPERTIES, CacheResourceDefinition.Attribute.INDEXING_PROPERTIES);
                    return Operations.createCompositeOperation((ModelNode[])new ModelNode[]{indexOperation, propertiesOperation});
                }

                private ModelNode translateParameter(PathAddress address, ModelNode operation, Attribute attribute, org.jboss.as.clustering.controller.Attribute legacyAttribute) {
                    String name = attribute.getDefinition().getName();
                    return operation.hasDefined(name) ? Operations.createWriteAttributeOperation((PathAddress)address, (org.jboss.as.clustering.controller.Attribute)legacyAttribute, (ModelNode)operation.get(name)) : Operations.createUndefineAttributeOperation((PathAddress)address, (org.jboss.as.clustering.controller.Attribute)legacyAttribute);
                }
            };
            builder.addRawOperationTransformationOverride("add", (OperationTransformer)new SimpleOperationTransformer(addTransformer));
            org.jboss.as.clustering.controller.transform.OperationTransformer removeTransformer = new org.jboss.as.clustering.controller.transform.OperationTransformer(){

                public ModelNode transformOperation(ModelNode operation) {
                    PathAddress cacheAddress = Operations.getPathAddress((ModelNode)operation).getParent();
                    ModelNode indexOperation = Operations.createUndefineAttributeOperation((PathAddress)cacheAddress, (org.jboss.as.clustering.controller.Attribute)CacheResourceDefinition.Attribute.INDEXING);
                    ModelNode propertiesOperation = Operations.createUndefineAttributeOperation((PathAddress)cacheAddress, (org.jboss.as.clustering.controller.Attribute)CacheResourceDefinition.Attribute.INDEXING_PROPERTIES);
                    return Operations.createCompositeOperation((ModelNode[])new ModelNode[]{indexOperation, propertiesOperation});
                }
            };
            builder.addRawOperationTransformationOverride("remove", (OperationTransformer)new SimpleOperationTransformer(removeTransformer));
            org.jboss.as.clustering.controller.transform.OperationTransformer readAttributeTransformer = new org.jboss.as.clustering.controller.transform.OperationTransformer(){

                public ModelNode transformOperation(ModelNode operation) {
                    PathAddress cacheAddress = Operations.getPathAddress((ModelNode)operation).getParent();
                    String name = Operations.getAttributeName((ModelNode)operation);
                    if (Attribute.INDEX.getDefinition().getName().equals(name)) {
                        return Operations.createReadAttributeOperation((PathAddress)cacheAddress, (org.jboss.as.clustering.controller.Attribute)CacheResourceDefinition.Attribute.INDEXING);
                    }
                    if (Attribute.PROPERTIES.getDefinition().getName().equals(name)) {
                        return Operations.createReadAttributeOperation((PathAddress)cacheAddress, (org.jboss.as.clustering.controller.Attribute)CacheResourceDefinition.Attribute.INDEXING_PROPERTIES);
                    }
                    return operation;
                }
            };
            builder.addRawOperationTransformationOverride("read-attribute", (OperationTransformer)new SimpleOperationTransformer(readAttributeTransformer));
            org.jboss.as.clustering.controller.transform.OperationTransformer writeAttributeTransformer = new org.jboss.as.clustering.controller.transform.OperationTransformer(){

                public ModelNode transformOperation(ModelNode operation) {
                    PathAddress cacheAddress = Operations.getPathAddress((ModelNode)operation).getParent();
                    String name = Operations.getAttributeName((ModelNode)operation);
                    ModelNode value = Operations.getAttributeValue((ModelNode)operation);
                    if (Attribute.INDEX.getDefinition().getName().equals(name)) {
                        return Operations.createWriteAttributeOperation((PathAddress)cacheAddress, (org.jboss.as.clustering.controller.Attribute)CacheResourceDefinition.Attribute.INDEXING, (ModelNode)value);
                    }
                    if (Attribute.PROPERTIES.getDefinition().getName().equals(name)) {
                        return Operations.createWriteAttributeOperation((PathAddress)cacheAddress, (org.jboss.as.clustering.controller.Attribute)CacheResourceDefinition.Attribute.INDEXING_PROPERTIES, (ModelNode)value);
                    }
                    return operation;
                }
            };
            builder.addRawOperationTransformationOverride("write-attribute", (OperationTransformer)new SimpleOperationTransformer(writeAttributeTransformer));
            org.jboss.as.clustering.controller.transform.OperationTransformer undefineAttributeTransformer = new org.jboss.as.clustering.controller.transform.OperationTransformer(){

                public ModelNode transformOperation(ModelNode operation) {
                    PathAddress cacheAddress = Operations.getPathAddress((ModelNode)operation).getParent();
                    String name = Operations.getAttributeName((ModelNode)operation);
                    if (Attribute.INDEX.getDefinition().getName().equals(name)) {
                        return Operations.createUndefineAttributeOperation((PathAddress)cacheAddress, (org.jboss.as.clustering.controller.Attribute)CacheResourceDefinition.Attribute.INDEXING);
                    }
                    if (Attribute.PROPERTIES.getDefinition().getName().equals(name)) {
                        return Operations.createUndefineAttributeOperation((PathAddress)cacheAddress, (org.jboss.as.clustering.controller.Attribute)CacheResourceDefinition.Attribute.INDEXING_PROPERTIES);
                    }
                    return operation;
                }
            };
            builder.addRawOperationTransformationOverride("undefine-attribute", (OperationTransformer)new SimpleOperationTransformer(undefineAttributeTransformer));
        }
    }

    IndexingResourceDefinition() {
        super(PATH);
    }

    public void registerOperations(ManagementResourceRegistration registration) {
        SimpleResourceServiceHandler handler = new SimpleResourceServiceHandler((ResourceServiceBuilderFactory)new IndexingBuilderFactory());
        new AddStepHandler(this.getResourceDescriptionResolver(), (ResourceServiceHandler)handler).addAttributes(Attribute.class).register(registration);
        new RemoveStepHandler(this.getResourceDescriptionResolver(), (ResourceServiceHandler)handler).register(registration);
    }

    public void registerAttributes(ManagementResourceRegistration registration) {
        new ReloadRequiredWriteAttributeHandler(Attribute.class).register(registration);
    }

    public void register(ManagementResourceRegistration registration) {
        registration.registerSubModel((ResourceDefinition)this);
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute
    {
        INDEX("index", ModelType.STRING, new ModelNode(Index.NONE.name()), (ParameterValidator)new EnumValidator(Index.class, true, false)),
        PROPERTIES("properties");

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, ModelNode defaultValue, ParameterValidator validator) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(false)).setAllowNull(true)).setDefaultValue(defaultValue)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setValidator(validator)).build();
        }

        private Attribute(String name) {
            this.definition = ((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)new SimpleMapAttributeDefinition.Builder(name, true).setAllowNull(true)).setAttributeMarshaller(AttributeMarshallers.PROPERTY_LIST)).setAttributeParser(AttributeParsers.COLLECTION)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

