/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.persistence.jdbc.DatabaseType;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.subsystem.JDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public abstract class JDBCStoreBuilder<C extends AbstractJdbcStoreConfiguration, B extends AbstractJdbcStoreConfigurationBuilder<C, B>>
extends StoreBuilder {
    private final Class<B> builderClass;
    private volatile String dataSource;

    JDBCStoreBuilder(Class<B> builderClass, String containerName, String cacheName) {
        super(containerName, cacheName);
        this.builderClass = builderClass;
    }

    @Override
    public ServiceBuilder<PersistenceConfiguration> build(ServiceTarget target) {
        return super.build(target).addDependency(ServiceName.JBOSS.append(new String[]{"data-source", this.dataSource}));
    }

    B createStore(ExpressionResolver resolver, ModelNode model) throws OperationFailedException {
        this.dataSource = JDBCStoreResourceDefinition.Attribute.DATA_SOURCE.getDefinition().resolveModelAttribute(resolver, model).asString();
        AbstractJdbcStoreConfigurationBuilder storeBuilder = ((AbstractJdbcStoreConfigurationBuilder)new ConfigurationBuilder().persistence().addStore(this.builderClass)).dialect((DatabaseType)ModelNodes.asEnum((ModelNode)JDBCStoreResourceDefinition.Attribute.DIALECT.getDefinition().resolveModelAttribute(resolver, model), DatabaseType.class));
        storeBuilder.dataSource().jndiUrl(this.dataSource);
        return (B)storeBuilder;
    }
}

