/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.configuration.global.TransportConfigurationBuilder;
import org.infinispan.remoting.transport.Transport;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.infinispan.ChannelTransport;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerComponent;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerComponentBuilder;
import org.jboss.as.clustering.infinispan.subsystem.JGroupsTransportResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jgroups.Channel;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.ProtocolStackConfiguration;
import org.wildfly.clustering.jgroups.spi.TransportConfiguration;
import org.wildfly.clustering.jgroups.spi.service.ChannelServiceName;
import org.wildfly.clustering.service.Builder;

public class JGroupsTransportBuilder
extends CacheContainerComponentBuilder<TransportConfiguration>
implements ResourceServiceBuilder<TransportConfiguration> {
    private final InjectedValue<Channel> channel = new InjectedValue();
    private final InjectedValue<ChannelFactory> factory = new InjectedValue();
    private final String containerName;
    private volatile long lockTimeout;

    public JGroupsTransportBuilder(String containerName) {
        super(CacheContainerComponent.TRANSPORT, containerName);
        this.containerName = containerName;
    }

    @Override
    public ServiceBuilder<TransportConfiguration> build(ServiceTarget target) {
        return super.build(target).addDependency(ChannelServiceName.CHANNEL.getServiceName(this.containerName), Channel.class, this.channel).addDependency(ChannelServiceName.FACTORY.getServiceName(this.containerName), ChannelFactory.class, this.factory);
    }

    public Builder<TransportConfiguration> configure(ExpressionResolver resolver, ModelNode model) throws OperationFailedException {
        this.lockTimeout = JGroupsTransportResourceDefinition.Attribute.LOCK_TIMEOUT.getDefinition().resolveModelAttribute(resolver, model).asLong();
        return this;
    }

    public TransportConfiguration getValue() throws IllegalStateException, IllegalArgumentException {
        Channel channel = (Channel)this.channel.getValue();
        ChannelFactory factory = (ChannelFactory)this.factory.getValue();
        ProtocolStackConfiguration stack = factory.getProtocolStackConfiguration();
        TransportConfiguration.Topology topology = stack.getTransport().getTopology();
        TransportConfigurationBuilder builder = new GlobalConfigurationBuilder().transport().clusterName(this.containerName).distributedSyncTimeout(this.lockTimeout).transport((Transport)new ChannelTransport(channel, factory));
        if (topology != null) {
            builder.siteId(topology.getSite()).rackId(topology.getRack()).machineId(topology.getMachine());
        }
        return builder.create();
    }
}

