/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.ServiceLoader;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerComponent;
import org.jboss.as.clustering.infinispan.subsystem.JGroupsTransportBuilder;
import org.jboss.as.clustering.infinispan.subsystem.JGroupsTransportResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.SiteBuilder;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsBindingFactory;
import org.jboss.as.clustering.naming.BinderServiceBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceTarget;
import org.jgroups.Channel;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.service.ChannelBuilder;
import org.wildfly.clustering.jgroups.spi.service.ChannelConnectorBuilder;
import org.wildfly.clustering.jgroups.spi.service.ChannelServiceName;
import org.wildfly.clustering.jgroups.spi.service.ProtocolStackServiceName;
import org.wildfly.clustering.service.AliasServiceBuilder;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.spi.GroupAliasBuilderProvider;

public class JGroupsTransportServiceHandler
implements ResourceServiceHandler {
    public void installServices(OperationContext context, ModelNode model) throws OperationFailedException {
        String name = context.getCurrentAddress().getParent().getLastElement().getValue();
        ServiceTarget target = context.getServiceTarget();
        String channel = ModelNodes.asString((ModelNode)JGroupsTransportResourceDefinition.Attribute.CHANNEL.getDefinition().resolveModelAttribute(context, model), (String)"default");
        new JGroupsTransportBuilder(name).configure((ExpressionResolver)context, model).build(target).install();
        new SiteBuilder(name).setChannelName(channel).build(target).install();
        new BinderServiceBuilder(JGroupsBindingFactory.createChannelBinding((String)name), ChannelServiceName.CHANNEL.getServiceName(name), Channel.class).build(target).install();
        new ChannelBuilder(name).build(target).install();
        new ChannelConnectorBuilder(name).build(target).install();
        new AliasServiceBuilder(ChannelServiceName.FACTORY.getServiceName(name), ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName(channel), ChannelFactory.class).build(target).install();
        for (GroupAliasBuilderProvider provider : ServiceLoader.load(GroupAliasBuilderProvider.class, GroupAliasBuilderProvider.class.getClassLoader())) {
            for (Builder builder : provider.getBuilders(name, channel)) {
                builder.build(target).install();
            }
        }
    }

    public void removeServices(OperationContext context, ModelNode model) throws OperationFailedException {
        String name = context.getCurrentAddress().getParent().getLastElement().getValue();
        String channel = ModelNodes.asString((ModelNode)JGroupsTransportResourceDefinition.Attribute.CHANNEL.getDefinition().resolveModelAttribute(context, model), (String)"default");
        for (GroupAliasBuilderProvider provider : ServiceLoader.load(GroupAliasBuilderProvider.class, GroupAliasBuilderProvider.class.getClassLoader())) {
            for (Builder builder : provider.getBuilders(name, channel)) {
                context.removeService(builder.getServiceName());
            }
        }
        for (ChannelServiceName channelServiceName : ChannelServiceName.values()) {
            context.removeService(channelServiceName.getServiceName(name));
        }
        for (CacheContainerComponent cacheContainerComponent : CacheContainerComponent.values()) {
            context.removeService(cacheContainerComponent.getServiceName(name));
        }
    }
}

