/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.LockingConfiguration;
import org.infinispan.configuration.cache.LockingConfigurationBuilder;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponentBuilder;
import org.jboss.as.clustering.infinispan.subsystem.LockingResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.service.Builder;

public class LockingBuilder
extends CacheComponentBuilder<LockingConfiguration>
implements ResourceServiceBuilder<LockingConfiguration> {
    private final LockingConfigurationBuilder builder = new ConfigurationBuilder().locking();

    LockingBuilder(String containerName, String cacheName) {
        super(CacheComponent.LOCKING, containerName, cacheName);
    }

    public LockingConfiguration getValue() {
        return this.builder.create();
    }

    public Builder<LockingConfiguration> configure(ExpressionResolver resolver, ModelNode model) throws OperationFailedException {
        this.builder.lockAcquisitionTimeout(LockingResourceDefinition.Attribute.ACQUIRE_TIMEOUT.getDefinition().resolveModelAttribute(resolver, model).asLong());
        this.builder.concurrencyLevel(LockingResourceDefinition.Attribute.CONCURRENCY.getDefinition().resolveModelAttribute(resolver, model).asInt());
        this.builder.isolationLevel((IsolationLevel)ModelNodes.asEnum((ModelNode)LockingResourceDefinition.Attribute.ISOLATION.getDefinition().resolveModelAttribute(resolver, model), IsolationLevel.class));
        this.builder.useLockStriping(LockingResourceDefinition.Attribute.STRIPING.getDefinition().resolveModelAttribute(resolver, model).asBoolean());
        return this;
    }
}

