/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.RemoteStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;

public class RemoteStoreBuilder
extends StoreBuilder {
    private final List<ValueDependency<OutboundSocketBinding>> bindings = new LinkedList<ValueDependency<OutboundSocketBinding>>();
    private volatile RemoteStoreConfigurationBuilder storeBuilder;

    public RemoteStoreBuilder(String containerName, String cacheName) {
        super(containerName, cacheName);
    }

    @Override
    public ServiceBuilder<PersistenceConfiguration> build(ServiceTarget target) {
        ServiceBuilder<PersistenceConfiguration> builder = super.build(target);
        for (Dependency dependency : this.bindings) {
            dependency.register(builder);
        }
        return builder;
    }

    @Override
    public PersistenceConfiguration getValue() {
        for (Value value : this.bindings) {
            OutboundSocketBinding binding = (OutboundSocketBinding)value.getValue();
            try {
                this.storeBuilder.addServer().host(binding.getResolvedDestinationAddress().getHostAddress()).port(binding.getDestinationPort());
            }
            catch (UnknownHostException e) {
                throw InfinispanLogger.ROOT_LOGGER.failedToInjectSocketBinding(e, binding);
            }
        }
        return super.getValue();
    }

    @Override
    StoreConfigurationBuilder<?, ?> createStore(ExpressionResolver resolver, ModelNode model) throws OperationFailedException {
        this.storeBuilder = ((RemoteStoreConfigurationBuilder)new ConfigurationBuilder().persistence().addStore(RemoteStoreConfigurationBuilder.class)).remoteCacheName(RemoteStoreResourceDefinition.Attribute.CACHE.getDefinition().resolveModelAttribute(resolver, model).asString()).socketTimeout(RemoteStoreResourceDefinition.Attribute.SOCKET_TIMEOUT.getDefinition().resolveModelAttribute(resolver, model).asLong()).tcpNoDelay(RemoteStoreResourceDefinition.Attribute.TCP_NO_DELAY.getDefinition().resolveModelAttribute(resolver, model).asBoolean());
        for (String binding : StringListAttributeDefinition.unwrapValue((ExpressionResolver)resolver, (ModelNode)RemoteStoreResourceDefinition.Attribute.SOCKET_BINDINGS.getDefinition().resolveModelAttribute(resolver, model))) {
            this.bindings.add((ValueDependency<OutboundSocketBinding>)new InjectedValueDependency(OutboundSocketBinding.OUTBOUND_SOCKET_BINDING_BASE_SERVICE_NAME.append(new String[]{binding}), OutboundSocketBinding.class));
        }
        return this.storeBuilder;
    }
}

