/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.ServiceLoader;
import java.util.function.Consumer;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.EvictionConfiguration;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.configuration.cache.GroupsConfigurationBuilder;
import org.infinispan.configuration.cache.JMXStatisticsConfiguration;
import org.infinispan.configuration.cache.LockingConfiguration;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.distribution.group.Grouper;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.infinispan.spi.service.CacheContainerServiceName;
import org.wildfly.clustering.infinispan.spi.service.CacheServiceName;
import org.wildfly.clustering.infinispan.spi.service.ConfigurationBuilder;
import org.wildfly.clustering.service.Builder;

public class CacheConfigurationBuilder
implements ResourceServiceBuilder<Configuration>,
Consumer<org.infinispan.configuration.cache.ConfigurationBuilder> {
    private final InjectedValue<EvictionConfiguration> eviction = new InjectedValue();
    private final InjectedValue<ExpirationConfiguration> expiration = new InjectedValue();
    private final InjectedValue<LockingConfiguration> locking = new InjectedValue();
    private final InjectedValue<PersistenceConfiguration> persistence = new InjectedValue();
    private final InjectedValue<TransactionConfiguration> transaction = new InjectedValue();
    private final InjectedValue<GlobalConfiguration> global = new InjectedValue();
    private final InjectedValue<ModuleLoader> loader = new InjectedValue();
    private final String containerName;
    private final String cacheName;
    private volatile JMXStatisticsConfiguration statistics;
    private volatile ModuleIdentifier module;

    CacheConfigurationBuilder(String containerName, String cacheName) {
        this.containerName = containerName;
        this.cacheName = cacheName;
    }

    public ServiceName getServiceName() {
        return CacheServiceName.CONFIGURATION.getServiceName(this.containerName, this.cacheName);
    }

    public ServiceBuilder<Configuration> build(ServiceTarget target) {
        return new ConfigurationBuilder(this.containerName, this.cacheName, this.andThen(builder -> {
            CacheMode mode = builder.clustering().cacheMode();
            if (mode.isSynchronous() && ((TransactionConfiguration)this.transaction.getValue()).lockingMode() == LockingMode.OPTIMISTIC && ((LockingConfiguration)this.locking.getValue()).isolationLevel() == IsolationLevel.REPEATABLE_READ) {
                builder.locking().writeSkewCheck(true);
                builder.versioning().enable().scheme(VersioningScheme.SIMPLE);
            }
            GroupsConfigurationBuilder groupsBuilder = builder.clustering().hash().groups().enabled();
            ServiceLoader.load(Grouper.class, this.getClassLoader()).forEach(grouper -> groupsBuilder.addGrouper(grouper));
        })).build(target).addDependency(CacheComponent.EVICTION.getServiceName(this.containerName, this.cacheName), EvictionConfiguration.class, this.eviction).addDependency(CacheComponent.EXPIRATION.getServiceName(this.containerName, this.cacheName), ExpirationConfiguration.class, this.expiration).addDependency(CacheComponent.LOCKING.getServiceName(this.containerName, this.cacheName), LockingConfiguration.class, this.locking).addDependency(CacheComponent.PERSISTENCE.getServiceName(this.containerName, this.cacheName), PersistenceConfiguration.class, this.persistence).addDependency(CacheComponent.TRANSACTION.getServiceName(this.containerName, this.cacheName), TransactionConfiguration.class, this.transaction).addDependency(CacheContainerServiceName.CONFIGURATION.getServiceName(this.containerName), GlobalConfiguration.class, this.global).addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ModuleLoader.class, this.loader);
    }

    public Builder<Configuration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.module = ModelNodes.asModuleIdentifier((ModelNode)CacheResourceDefinition.Attribute.MODULE.getDefinition().resolveModelAttribute(context, model));
        boolean enabled = CacheResourceDefinition.Attribute.STATISTICS_ENABLED.getDefinition().resolveModelAttribute(context, model).asBoolean();
        this.statistics = new org.infinispan.configuration.cache.ConfigurationBuilder().jmxStatistics().enabled(enabled).available(enabled).create();
        return this;
    }

    @Override
    public void accept(org.infinispan.configuration.cache.ConfigurationBuilder builder) {
        builder.eviction().read((EvictionConfiguration)this.eviction.getValue());
        builder.expiration().read((ExpirationConfiguration)this.expiration.getValue());
        builder.locking().read((LockingConfiguration)this.locking.getValue());
        builder.persistence().read((PersistenceConfiguration)this.persistence.getValue());
        builder.transaction().read((TransactionConfiguration)this.transaction.getValue());
        builder.jmxStatistics().read(this.statistics);
    }

    private ClassLoader getClassLoader() {
        if (this.module != null) {
            try {
                return ((ModuleLoader)this.loader.getValue()).loadModule(this.module).getClassLoader();
            }
            catch (ModuleLoadException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return ((GlobalConfiguration)this.global.getValue()).classLoader();
    }
}

