/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan;

import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cache.impl.AbstractDelegatingAdvancedCache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.clustering.infinispan.BatcherFactory;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;

public class DefaultCache<K, V>
extends AbstractDelegatingAdvancedCache<K, V> {
    private static final ThreadLocal<Batch> CURRENT_BATCH = new ThreadLocal();
    private final EmbeddedCacheManager manager;
    private final Batcher<? extends Batch> batcher;

    DefaultCache(final EmbeddedCacheManager manager, final Batcher<? extends Batch> batcher, AdvancedCache<K, V> cache) {
        super(cache, new AbstractDelegatingAdvancedCache.AdvancedCacheWrapper<K, V>(){

            public AdvancedCache<K, V> wrap(AdvancedCache<K, V> cache) {
                return new DefaultCache(manager, (Batcher<? extends Batch>)batcher, cache);
            }
        });
        this.manager = manager;
        this.batcher = batcher;
    }

    public DefaultCache(EmbeddedCacheManager manager, BatcherFactory batcherFactory, AdvancedCache<K, V> cache) {
        this(manager, batcherFactory.createBatcher((Cache<?, ?>)cache), cache);
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.manager;
    }

    public boolean startBatch() {
        if (this.batcher == null) {
            return false;
        }
        if (CURRENT_BATCH.get() != null) {
            return false;
        }
        CURRENT_BATCH.set(this.batcher.createBatch());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endBatch(boolean successful) {
        try (Batch batch = CURRENT_BATCH.get();){
            if (batch != null && !successful) {
                batch.discard();
            }
        }
        finally {
            CURRENT_BATCH.remove();
        }
    }

    public boolean equals(Object object) {
        return object == this || object == this.cache;
    }

    public int hashCode() {
        return this.cache.hashCode();
    }
}

