/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.HashConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.impl.DefaultConsistentHashFactory;
import org.infinispan.distribution.ch.impl.TopologyAwareConsistentHashFactory;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ConsistentHashStrategy;
import org.jboss.as.clustering.infinispan.subsystem.SegmentedCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.SharedStateCacheBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;

public class SegmentedCacheBuilder
extends SharedStateCacheBuilder {
    private final ValueDependency<GlobalConfiguration> global;
    private volatile ConsistentHashStrategy consistentHashStrategy;
    private volatile int segments;

    SegmentedCacheBuilder(PathAddress address, CacheMode mode) {
        super(address, mode);
        this.global = new InjectedValueDependency(CacheContainerResourceDefinition.Capability.CONFIGURATION.getServiceName(address.getParent()), GlobalConfiguration.class);
    }

    @Override
    public ServiceBuilder<Configuration> build(ServiceTarget target) {
        return this.global.register(super.build(target));
    }

    @Override
    public Builder<Configuration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.consistentHashStrategy = (ConsistentHashStrategy)ModelNodes.asEnum((ModelNode)SegmentedCacheResourceDefinition.Attribute.CONSISTENT_HASH_STRATEGY.resolveModelAttribute((ExpressionResolver)context, model), ConsistentHashStrategy.class);
        this.segments = SegmentedCacheResourceDefinition.Attribute.SEGMENTS.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        return super.configure(context, model);
    }

    @Override
    public void accept(ConfigurationBuilder builder) {
        super.accept(builder);
        HashConfigurationBuilder hash = builder.clustering().hash().numSegments(this.segments);
        if (this.consistentHashStrategy == ConsistentHashStrategy.INTRA_CACHE) {
            hash.consistentHashFactory((ConsistentHashFactory)(((GlobalConfiguration)this.global.getValue()).transport().hasTopologyInfo() ? new TopologyAwareConsistentHashFactory() : new DefaultConsistentHashFactory()));
        }
    }
}

