/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem.remote;

import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ConnectionPoolConfiguration;
import org.infinispan.client.hotrod.configuration.ExhaustedAction;
import org.jboss.as.clustering.infinispan.subsystem.ComponentBuilder;
import org.jboss.as.clustering.infinispan.subsystem.remote.ConnectionPoolResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerComponent;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.service.Builder;

public class ConnectionPoolBuilder
extends ComponentBuilder<ConnectionPoolConfiguration> {
    private volatile ExhaustedAction exhaustedAction;
    private volatile int maxActive;
    private volatile long maxWait;
    private volatile long minEvictableIdleTime;
    private volatile int minIdle;

    ConnectionPoolBuilder(PathAddress address) {
        super(RemoteCacheContainerComponent.CONNECTION_POOL, address);
    }

    public Builder<ConnectionPoolConfiguration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.exhaustedAction = ExhaustedAction.valueOf((String)ConnectionPoolResourceDefinition.Attribute.EXHAUSTED_ACTION.resolveModelAttribute((ExpressionResolver)context, model).asString());
        this.maxActive = ConnectionPoolResourceDefinition.Attribute.MAX_ACTIVE.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        this.maxWait = ConnectionPoolResourceDefinition.Attribute.MAX_WAIT.resolveModelAttribute((ExpressionResolver)context, model).asLong();
        this.minEvictableIdleTime = ConnectionPoolResourceDefinition.Attribute.MIN_EVICTABLE_IDLE_TIME.resolveModelAttribute((ExpressionResolver)context, model).asLong();
        this.minIdle = ConnectionPoolResourceDefinition.Attribute.MIN_IDLE.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        return this;
    }

    public ConnectionPoolConfiguration getValue() throws IllegalStateException, IllegalArgumentException {
        return new ConfigurationBuilder().connectionPool().exhaustedAction(this.exhaustedAction).maxActive(this.maxActive).maxWait(this.maxWait).minEvictableIdleTime(this.minEvictableIdleTime).minIdle(this.minIdle).create();
    }
}

