package org.jboss.as.clustering.infinispan;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import org.jboss.as.controller.OperationFailedException;
import java.lang.Throwable;
import java.lang.String;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2020-02-10T11:31:57-0600")
public class InfinispanLogger_$logger extends DelegatingBasicLogger implements InfinispanLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = InfinispanLogger_$logger.class.getName();
    public InfinispanLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void activatingSubsystem() {
        super.log.logf(FQCN, INFO, null, activatingSubsystem$str());
    }
    protected String activatingSubsystem$str() {
        return "WFLYCLINF0001: Activating Infinispan subsystem.";
    }
    @Override
    public final void cacheStarted(final String cacheName, final String containerName) {
        super.log.logf(FQCN, INFO, null, cacheStarted$str(), cacheName, containerName);
    }
    protected String cacheStarted$str() {
        return "WFLYCLINF0002: Started %s cache from %s container";
    }
    @Override
    public final void cacheStopped(final String cacheName, final String containerName) {
        super.log.logf(FQCN, INFO, null, cacheStopped$str(), cacheName, containerName);
    }
    protected String cacheStopped$str() {
        return "WFLYCLINF0003: Stopped %s cache from %s container";
    }
    @Override
    public final void attributeDeprecated(final String attribute, final String element) {
        super.log.logf(FQCN, WARN, null, attributeDeprecated$str(), attribute, element);
    }
    protected String attributeDeprecated$str() {
        return "WFLYCLINF0004: The '%s' attribute of the '%s' element is no longer supported and will be ignored";
    }
    @Override
    public final void topologyAttributeDeprecated(final String attribute) {
        super.log.logf(FQCN, WARN, null, topologyAttributeDeprecated$str(), attribute);
    }
    protected String topologyAttributeDeprecated$str() {
        return "WFLYCLINF0005: The '%s' attribute specified on the 'transport' element of a cache container is no longer valid; use the same attribute specified on the 'transport' element of corresponding JGroups stack instead";
    }
    protected String dataSourceJndiNameNotFound$str() {
        return "WFLYCLINF0006: Failed to locate a data source bound to %s";
    }
    @Override
    public final OperationFailedException dataSourceJndiNameNotFound(final String jndiName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), dataSourceJndiNameNotFound$str(), jndiName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String dataSourceNotFound$str() {
        return "WFLYCLINF0007: Failed to locate data source %s";
    }
    @Override
    public final OperationFailedException dataSourceNotFound(final String name) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), dataSourceNotFound$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidCacheStore$str() {
        return "WFLYCLINF0010: %s is not a valid cache store";
    }
    @Override
    public final IllegalArgumentException invalidCacheStore(final Throwable cause, final String cacheStoreName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidCacheStore$str(), cacheStoreName), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String indeterminiteStack$str() {
        return "WFLYCLINF0027: Could not determine 'stack' attribute from JGroups subsystem";
    }
    @Override
    public final String indeterminiteStack() {
        return String.format(getLoggingLocale(), indeterminiteStack$str());
    }
    @Override
    public final void executorIgnored(final String executorName) {
        super.log.logf(FQCN, WARN, null, executorIgnored$str(), executorName);
    }
    protected String executorIgnored$str() {
        return "WFLYCLINF0028: Executor configuration '%s' was deprecated and will only be used to support legacy slaves in the domain.";
    }
    @Override
    public final void remoteCacheContainerStarted(final String remoteCacheContainer) {
        super.log.logf(FQCN, INFO, null, remoteCacheContainerStarted$str(), remoteCacheContainer);
    }
    protected String remoteCacheContainerStarted$str() {
        return "WFLYCLINF0029: Started remote cache container '%s'.";
    }
    @Override
    public final void remoteCacheContainerStopped(final String remoteCacheContainer) {
        super.log.logf(FQCN, INFO, null, remoteCacheContainerStopped$str(), remoteCacheContainer);
    }
    protected String remoteCacheContainerStopped$str() {
        return "WFLYCLINF0030: Stopped remote cache container '%s'.";
    }
    protected String remoteCacheMustBeDefined$str() {
        return "WFLYCLINF0031: Specified HotRod protocol version %s does not support creating caches automatically. Cache named '%s' must be already created on the Infinispan Server!";
    }
    @Override
    public final HotRodClientException remoteCacheMustBeDefined(final String protocolVersion, final String remoteCacheName) {
        final HotRodClientException result = new HotRodClientException(String.format(getLoggingLocale(), remoteCacheMustBeDefined$str(), protocolVersion, remoteCacheName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void remoteCacheCreated(final String remoteCacheName, final String cacheConfiguration) {
        super.log.logf(FQCN, INFO, null, remoteCacheCreated$str(), remoteCacheName, cacheConfiguration);
    }
    protected String remoteCacheCreated$str() {
        return "WFLYCLINF0032: Getting remote cache named '%s'. If it does not exist a new cache will be created from configuration template named '%s'; null value uses default cache configuration on the Infinispan Server.";
    }
}
